/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ModuleAttribute
implements Attribute {
    public static final String NAME = "Module";
    public static final int ACC_OPEN = 32;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_MANDATED = 32768;
    public final String module_name;
    public final int module_flags;
    public final String module_version;
    public final Require[] requires;
    public final Export[] exports;
    public final Open[] opens;
    public final String[] uses;
    public final Provide[] provides;

    public ModuleAttribute(String module_name, int module_flags, String module_version, Require[] requires, Export[] exports, Open[] opens, String[] uses, Provide[] provides) {
        this.module_name = module_name;
        this.module_flags = module_flags;
        this.module_version = module_version;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "Module " + this.module_name + " " + this.module_version + " " + this.module_flags;
    }

    public static ModuleAttribute read(DataInput in, ConstantPool constant_pool) throws IOException {
        int module_name_index = in.readUnsignedShort();
        int module_flags = in.readUnsignedShort();
        int module_version_index = in.readUnsignedShort();
        int requires_count = in.readUnsignedShort();
        Require[] requires = new Require[requires_count];
        for (int i = 0; i < requires_count; ++i) {
            requires[i] = Require.read(in, constant_pool);
        }
        int exports_count = in.readUnsignedShort();
        Export[] exports = new Export[exports_count];
        for (int i = 0; i < exports_count; ++i) {
            exports[i] = Export.read(in, constant_pool);
        }
        int opens_count = in.readUnsignedShort();
        Open[] opens = new Open[opens_count];
        for (int i = 0; i < opens_count; ++i) {
            opens[i] = Open.read(in, constant_pool);
        }
        int uses_count = in.readUnsignedShort();
        String[] uses = new String[uses_count];
        for (int i = 0; i < uses_count; ++i) {
            int uses_index = in.readUnsignedShort();
            uses[i] = constant_pool.className(uses_index);
        }
        int provides_count = in.readUnsignedShort();
        Provide[] provides = new Provide[provides_count];
        for (int i = 0; i < provides_count; ++i) {
            provides[i] = Provide.read(in, constant_pool);
        }
        return new ModuleAttribute(constant_pool.moduleName(module_name_index), module_flags, module_version_index != 0 ? constant_pool.utf8(module_version_index) : null, requires, exports, opens, uses, provides);
    }

    @Override
    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int attribute_name_index = constant_pool.utf8Info(this.name());
        int attribute_length = this.attribute_length();
        out.writeShort(attribute_name_index);
        out.writeInt(attribute_length);
        int module_name_index = constant_pool.moduleInfo(this.module_name);
        int module_version_index = this.module_version != null ? constant_pool.utf8Info(this.module_version) : 0;
        out.writeShort(module_name_index);
        out.writeShort(this.module_flags);
        out.writeShort(module_version_index);
        out.writeShort(this.requires.length);
        for (Require require : this.requires) {
            require.write(out, constant_pool);
        }
        out.writeShort(this.exports.length);
        for (Export export : this.exports) {
            export.write(out, constant_pool);
        }
        out.writeShort(this.opens.length);
        for (Open open : this.opens) {
            open.write(out, constant_pool);
        }
        out.writeShort(this.uses.length);
        for (String use : this.uses) {
            int uses_index = constant_pool.classInfo(use);
            out.writeShort(uses_index);
        }
        out.writeShort(this.provides.length);
        for (Provide provide : this.provides) {
            provide.write(out, constant_pool);
        }
    }

    @Override
    public int attribute_length() {
        int attribute_length = (8 + this.uses.length) * 2;
        for (Require require : this.requires) {
            attribute_length += require.value_length();
        }
        for (Export export : this.exports) {
            attribute_length += export.value_length();
        }
        for (Open open : this.opens) {
            attribute_length += open.value_length();
        }
        for (Provide provide : this.provides) {
            attribute_length += provide.value_length();
        }
        return attribute_length;
    }

    public static class Require {
        public static final int ACC_TRANSITIVE = 32;
        public static final int ACC_STATIC_PHASE = 64;
        public static final int ACC_SYNTHETIC = 4096;
        public static final int ACC_MANDATED = 32768;
        public final String requires;
        public final int requires_flags;
        public final String requires_version;

        public Require(String requires, int requires_flags, String requires_version) {
            this.requires = requires;
            this.requires_flags = requires_flags;
            this.requires_version = requires_version;
        }

        public String toString() {
            return this.requires + " " + this.requires_version + " " + this.requires_flags;
        }

        static Require read(DataInput in, ConstantPool constant_pool) throws IOException {
            int requires_index = in.readUnsignedShort();
            int requires_flags = in.readUnsignedShort();
            int requires_version_index = in.readUnsignedShort();
            return new Require(constant_pool.moduleName(requires_index), requires_flags, requires_version_index != 0 ? constant_pool.utf8(requires_version_index) : null);
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeShort(constant_pool.moduleInfo(this.requires));
            out.writeShort(this.requires_flags);
            out.writeShort(this.requires_version != null ? constant_pool.utf8Info(this.requires_version) : 0);
        }

        int value_length() {
            return 6;
        }
    }

    public static class Export {
        public static final int ACC_SYNTHETIC = 4096;
        public static final int ACC_MANDATED = 32768;
        public final String exports;
        public final int exports_flags;
        public final String[] exports_to;

        public Export(String exports, int exports_flags, String[] exports_to) {
            this.exports = exports;
            this.exports_flags = exports_flags;
            this.exports_to = exports_to;
        }

        public String toString() {
            return this.exports + " " + Arrays.toString(this.exports_to) + " " + this.exports_flags;
        }

        static Export read(DataInput in, ConstantPool constant_pool) throws IOException {
            int exports_index = in.readUnsignedShort();
            int exports_flags = in.readUnsignedShort();
            int exports_to_count = in.readUnsignedShort();
            String[] exports_to = new String[exports_to_count];
            for (int i = 0; i < exports_to_count; ++i) {
                int exports_to_index = in.readUnsignedShort();
                exports_to[i] = constant_pool.moduleName(exports_to_index);
            }
            return new Export(constant_pool.packageName(exports_index), exports_flags, exports_to);
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeShort(constant_pool.packageInfo(this.exports));
            out.writeShort(this.exports_flags);
            out.writeShort(this.exports_to.length);
            for (String to : this.exports_to) {
                out.writeShort(constant_pool.moduleInfo(to));
            }
        }

        int value_length() {
            return (3 + this.exports_to.length) * 2;
        }
    }

    public static class Open {
        public static final int ACC_SYNTHETIC = 4096;
        public static final int ACC_MANDATED = 32768;
        public final String opens;
        public final int opens_flags;
        public final String[] opens_to;

        public Open(String opens, int opens_flags, String[] opens_to) {
            this.opens = opens;
            this.opens_flags = opens_flags;
            this.opens_to = opens_to;
        }

        public String toString() {
            return this.opens + " " + Arrays.toString(this.opens_to) + " " + this.opens_flags;
        }

        static Open read(DataInput in, ConstantPool constant_pool) throws IOException {
            int opens_index = in.readUnsignedShort();
            int opens_flags = in.readUnsignedShort();
            int opens_to_count = in.readUnsignedShort();
            String[] opens_to = new String[opens_to_count];
            for (int i = 0; i < opens_to_count; ++i) {
                int opens_to_index = in.readUnsignedShort();
                opens_to[i] = constant_pool.moduleName(opens_to_index);
            }
            return new Open(constant_pool.packageName(opens_index), opens_flags, opens_to);
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeShort(constant_pool.packageInfo(this.opens));
            out.writeShort(this.opens_flags);
            out.writeShort(this.opens_to.length);
            for (String to : this.opens_to) {
                out.writeShort(constant_pool.moduleInfo(to));
            }
        }

        int value_length() {
            return (3 + this.opens_to.length) * 2;
        }
    }

    public static class Provide {
        public final String provides;
        public final String[] provides_with;

        public Provide(String provides, String[] provides_with) {
            this.provides = provides;
            this.provides_with = provides_with;
        }

        public String toString() {
            return this.provides + " " + Arrays.toString(this.provides_with);
        }

        static Provide read(DataInput in, ConstantPool constant_pool) throws IOException {
            int provides_index = in.readUnsignedShort();
            int provides_with_count = in.readUnsignedShort();
            String[] provides_with = new String[provides_with_count];
            for (int i = 0; i < provides_with_count; ++i) {
                int provides_with_index = in.readUnsignedShort();
                provides_with[i] = constant_pool.className(provides_with_index);
            }
            return new Provide(constant_pool.className(provides_index), provides_with);
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeShort(constant_pool.classInfo(this.provides));
            out.writeShort(this.provides_with.length);
            for (String with : this.provides_with) {
                out.writeShort(constant_pool.classInfo(with));
            }
        }

        int value_length() {
            return (2 + this.provides_with.length) * 2;
        }
    }
}

