/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PercolateQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final JsonData document;
    private final List<JsonData> documents;
    private final String field;
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final String name;
    @Nullable
    private final String preference;
    @Nullable
    private final String routing;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PercolateQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercolateQuery::setupPercolateQueryDeserializer);

    private PercolateQuery(Builder builder) {
        super(builder);
        this.document = builder.document;
        this.documents = ApiTypeHelper.unmodifiable(builder.documents);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.id = builder.id;
        this.index = builder.index;
        this.name = builder.name;
        this.preference = builder.preference;
        this.routing = builder.routing;
        this.version = builder.version;
    }

    public static PercolateQuery of(Function<Builder, ObjectBuilder<PercolateQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Percolate;
    }

    @Nullable
    public final JsonData document() {
        return this.document;
    }

    public final List<JsonData> documents() {
        return this.documents;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.document != null) {
            generator.writeKey("document");
            this.document.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.documents)) {
            generator.writeKey("documents");
            generator.writeStartArray();
            for (JsonData item0 : this.documents) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.preference != null) {
            generator.writeKey("preference");
            generator.write(this.preference);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPercolateQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::document, JsonData._DESERIALIZER, "document");
        op.add(Builder::documents, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonData._DESERIALIZER), "documents");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::preference, JsonpDeserializer.stringDeserializer(), "preference");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercolateQuery> {
        @Nullable
        private JsonData document;
        @Nullable
        private List<JsonData> documents;
        private String field;
        @Nullable
        private String id;
        @Nullable
        private String index;
        @Nullable
        private String name;
        @Nullable
        private String preference;
        @Nullable
        private String routing;
        @Nullable
        private Long version;

        public final Builder document(@Nullable JsonData value) {
            this.document = value;
            return this;
        }

        public final Builder documents(List<JsonData> list) {
            this.documents = Builder._listAddAll(this.documents, list);
            return this;
        }

        public final Builder documents(JsonData value, JsonData ... values) {
            this.documents = Builder._listAdd(this.documents, value, values);
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercolateQuery build() {
            this._checkSingleUse();
            return new PercolateQuery(this);
        }
    }
}

