/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.PreparedStatementPartImpl;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.MapHelper;
import org.apache.torque.map.TableMap;
import org.apache.torque.sql.JoinBuilder;
import org.apache.torque.sql.OrderBy;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.CurrentDateTimePsPartBuilder;
import org.apache.torque.sql.whereclausebuilder.EnumValueBuilder;
import org.apache.torque.sql.whereclausebuilder.InBuilder;
import org.apache.torque.sql.whereclausebuilder.LikeBuilder;
import org.apache.torque.sql.whereclausebuilder.NullValueBuilder;
import org.apache.torque.sql.whereclausebuilder.StandardBuilder;
import org.apache.torque.sql.whereclausebuilder.VerbatimSqlConditionBuilder;
import org.apache.torque.sql.whereclausebuilder.WhereClausePsPartBuilder;
import org.apache.torque.util.UniqueColumnList;
import org.apache.torque.util.UniqueList;

public final class SqlBuilder {
    protected static final Logger log = LogManager.getLogger(SqlBuilder.class);
    public static final String[] FUNCTION_DELIMITERS = new String[]{" ", ",", "(", ")", "<", ">"};
    private static List<WhereClausePsPartBuilder> whereClausePsPartBuilders = new ArrayList<WhereClausePsPartBuilder>();

    private SqlBuilder() {
    }

    public static List<WhereClausePsPartBuilder> getWhereClausePsPartBuilders() {
        return whereClausePsPartBuilders;
    }

    public static Query buildQuery(Criteria crit) throws TorqueException {
        Query sqlStatement = new Query();
        JoinBuilder.processJoins(crit, sqlStatement);
        SqlBuilder.processModifiers(crit, sqlStatement);
        SqlBuilder.processSelectColumns(crit, sqlStatement);
        SqlBuilder.processAsColumns(crit, sqlStatement);
        SqlBuilder.processCriterions(crit, sqlStatement);
        SqlBuilder.processGroupBy(crit, sqlStatement);
        SqlBuilder.processHaving(crit, sqlStatement);
        SqlBuilder.processOrderBy(crit, sqlStatement);
        SqlBuilder.processSetOperations(crit, sqlStatement);
        SqlBuilder.processLimits(crit, sqlStatement);
        SqlBuilder.processFromElements(crit, sqlStatement);
        SqlBuilder.processForUpdate(crit, sqlStatement);
        sqlStatement.setFetchSize(crit.getFetchSize());
        return sqlStatement;
    }

    private static void processSelectColumns(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isComposite()) {
            return;
        }
        UniqueList<String> selectClause = query.getSelectClause();
        UniqueColumnList selectColumns = criteria.getSelectColumns();
        for (Column column : selectColumns) {
            String sqlExpression = column.getSqlExpression();
            Column resolvedAlias = criteria.getAsColumns().get(sqlExpression);
            if (resolvedAlias != null) continue;
            selectClause.add(sqlExpression);
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processAsColumns(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isComposite()) {
            return;
        }
        UniqueList<String> querySelectClause = query.getSelectClause();
        Map<String, Column> criteriaAsColumns = criteria.getAsColumns();
        for (Map.Entry<String, Column> entry : criteriaAsColumns.entrySet()) {
            Column column = entry.getValue();
            querySelectClause.add(column.getSqlExpression() + String.valueOf(SqlEnum.AS) + entry.getKey());
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processModifiers(Criteria criteria, Query query) {
        if (criteria.isComposite()) {
            return;
        }
        UniqueList<String> selectModifiers = query.getSelectModifiers();
        UniqueList<String> modifiers = criteria.getSelectModifiers();
        for (String modifier : modifiers) {
            selectModifiers.add(modifier);
        }
    }

    private static void processCriterions(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isComposite() || criteria.getTopLevelCriterion() == null) {
            return;
        }
        StringBuilder where = new StringBuilder();
        SqlBuilder.appendCriterion(criteria.getTopLevelCriterion(), criteria, where, query);
        query.getWhereClause().add(where.toString());
    }

    static void appendCriterion(Criterion criterion, Criteria criteria, StringBuilder where, Query query) throws TorqueException {
        if (criterion.isComposite()) {
            where.append('(');
            boolean firstPart = true;
            for (Criterion part : criterion.getParts()) {
                if (!firstPart) {
                    where.append(criterion.getConjunction());
                }
                SqlBuilder.appendCriterion(part, criteria, where, query);
                firstPart = false;
            }
            where.append(')');
            return;
        }
        SqlBuilder.addTableToFromClause(criterion.getLValue(), criteria, query);
        SqlBuilder.addTableToFromClause(criterion.getRValue(), criteria, query);
        PreparedStatementPart whereClausePartOutput = SqlBuilder.processCriterion(criterion, criteria, query);
        where.append(whereClausePartOutput.getSqlAsString());
        query.getWhereClausePreparedStatementReplacements().addAll(whereClausePartOutput.getPreparedStatementReplacements());
    }

    static PreparedStatementPart processCriterion(Criterion criterion, Criteria criteria, Query query) throws TorqueException {
        String dbName = criteria.getDbName();
        Database database = Torque.getDatabase(dbName);
        Adapter adapter = Torque.getAdapter(dbName);
        boolean ignoreCase = SqlBuilder.isIgnoreCase(criterion, criteria, database);
        WhereClauseExpression whereClausePartInput = new WhereClauseExpression(criterion.getLValue(), criterion.getComparison(), criterion.getRValue(), criterion.getSql(), criterion.getPreparedStatementReplacements());
        PreparedStatementPart whereClausePartOutput = null;
        for (WhereClausePsPartBuilder builder : whereClausePsPartBuilders) {
            if (!builder.isApplicable(whereClausePartInput, adapter)) continue;
            whereClausePartOutput = builder.buildPs(whereClausePartInput, ignoreCase, query, adapter);
            break;
        }
        if (whereClausePartOutput == null) {
            throw new RuntimeException("No handler found for whereClausePart " + String.valueOf(whereClausePartInput));
        }
        return whereClausePartOutput;
    }

    private static void processOrderBy(Criteria criteria, Query query) throws TorqueException {
        UniqueList<String> orderByClause = query.getOrderByClause();
        UniqueList<String> selectClause = query.getSelectClause();
        UniqueList<OrderBy> orderByList = criteria.getOrderByColumns();
        for (OrderBy orderBy : orderByList) {
            Column column = orderBy.getColumn();
            ColumnMap columnMap = MapHelper.getColumnMap(column, criteria);
            String sqlExpression = column.getSqlExpression();
            if (columnMap == null || columnMap.getType() instanceof String && sqlExpression.indexOf(40) == -1) {
                if (orderBy.isIgnoreCase() || criteria.isIgnoreCase()) {
                    Adapter adapter = Torque.getAdapter(criteria.getDbName());
                    orderByClause.add(adapter.ignoreCaseInOrderBy(sqlExpression) + " " + String.valueOf(orderBy.getOrder()));
                    selectClause.add(adapter.ignoreCaseInOrderBy(sqlExpression));
                } else {
                    orderByClause.add(sqlExpression + " " + String.valueOf(orderBy.getOrder()));
                    if (criteria.getAsColumns().get(sqlExpression) == null) {
                        selectClause.add(sqlExpression);
                    }
                }
            } else {
                orderByClause.add(sqlExpression + " " + String.valueOf(orderBy.getOrder()));
                if (criteria.getAsColumns().get(sqlExpression) == null) {
                    selectClause.add(sqlExpression);
                }
            }
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processGroupBy(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isComposite()) {
            return;
        }
        UniqueList<String> groupByClause = query.getGroupByClause();
        UniqueColumnList groupBy = criteria.getGroupByColumns();
        for (Column groupByColumn : groupBy) {
            Column column = criteria.getAsColumns().get(groupByColumn.getSqlExpression());
            if (column == null) {
                column = groupByColumn;
            }
            groupByClause.add(column.getSqlExpression());
            SqlBuilder.addTableToFromClause(column, criteria, query);
        }
    }

    private static void processHaving(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isComposite()) {
            return;
        }
        Criterion having = criteria.getHaving();
        if (having != null) {
            query.setHaving(having.toString());
        }
    }

    private static void processLimits(Criteria criteria, Query query) throws TorqueException {
        int limit = criteria.getLimit();
        long offset = criteria.getOffset();
        if (offset > 0L || limit >= 0) {
            Adapter adapter = Torque.getAdapter(criteria.getDbName());
            adapter.generateLimits(query, offset, limit);
        }
    }

    private static void processFromElements(Criteria criteria, Query query) {
        if (criteria.isComposite()) {
            return;
        }
        if (criteria.getFromElements().isEmpty()) {
            log.trace("criteria's from Elements is empty, using automatically calculated from clause");
            return;
        }
        query.getFromClause().clear();
        query.getFromClause().addAll(criteria.getFromElements());
    }

    private static void processForUpdate(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isForUpdate()) {
            Adapter adapter = Torque.getAdapter(criteria.getDbName());
            query.setForUpdate(adapter.getUpdateLockClause());
        }
    }

    private static void processSetOperations(Criteria criteria, Query query) throws TorqueException {
        if (!criteria.isComposite()) {
            return;
        }
        String dbName = criteria.getDbName();
        Adapter adapter = Torque.getAdapter(dbName);
        SqlEnum setOperator = criteria.getSetOperator();
        if (adapter.useMinusForExcept()) {
            if (SqlEnum.EXCEPT == setOperator) {
                setOperator = SqlEnum.MINUS;
            } else if (SqlEnum.EXCEPT_ALL == setOperator) {
                setOperator = SqlEnum.MINUS_ALL;
            }
        }
        query.setPartOperator(setOperator.toString());
        for (Criteria part : criteria.getSetCriteriaParts()) {
            Query queryPart = SqlBuilder.buildQuery(part);
            query.getParts().add(queryPart);
        }
    }

    static PreparedStatementPart getExpressionForFromClause(Object toAddToFromClause, Criteria criteria) throws TorqueException {
        if (!(toAddToFromClause instanceof Column)) {
            return new PreparedStatementPartImpl("?", toAddToFromClause);
        }
        Column column = (Column)toAddToFromClause;
        Column resolvedColumn = SqlBuilder.resolveAliasAndAsColumnAndSchema(column, criteria);
        String fullTableName = resolvedColumn.getFullTableName();
        if (!StringUtils.equals((CharSequence)resolvedColumn.getTableName(), (CharSequence)column.getTableName())) {
            PreparedStatementPartImpl result = new PreparedStatementPartImpl();
            result.getSql().append(fullTableName).append(" ").append(column.getTableName());
            return result;
        }
        Object resolvedAlias = criteria.getAliases().get(resolvedColumn.getTableName());
        if (resolvedAlias != null) {
            if (resolvedAlias instanceof Criteria) {
                Criteria subquery = (Criteria)resolvedAlias;
                Query renderedSubquery = SqlBuilder.buildQuery(subquery);
                PreparedStatementPartImpl result = new PreparedStatementPartImpl();
                result.getSql().append("(").append(renderedSubquery.toString()).append(") ").append(resolvedColumn.getTableName());
                result.getPreparedStatementReplacements().addAll(renderedSubquery.getPreparedStatementReplacements());
                return result;
            }
            throw new TorqueException("Table name " + resolvedColumn.getTableName() + " resolved to an unhandleable class " + resolvedAlias.getClass().getName());
        }
        return new PreparedStatementPartImpl(fullTableName, new Object[0]);
    }

    public static String getFullTableName(String table, String dbName) throws TorqueException {
        String targetDBName;
        String targetSchema;
        if (table == null) {
            return table;
        }
        int dotIndex = table.indexOf(".");
        if (dotIndex == -1 && StringUtils.isNotEmpty((CharSequence)(targetSchema = Torque.getSchema(targetDBName = dbName == null ? Torque.getDefaultDB() : dbName)))) {
            return targetSchema + "." + table;
        }
        return table;
    }

    public static String getUnqualifiedName(String name, String dbName) throws TorqueException {
        if (name == null) {
            return null;
        }
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(dotIndex + 1);
    }

    public static String guessFullTableFromCriteria(Criteria criteria) throws TorqueException {
        Criterion criterion = criteria.getTopLevelCriterion();
        if (criterion == null) {
            throw new TorqueException("Could not determine table name  as criteria contains no criterion");
        }
        while (criterion.isComposite()) {
            criterion = criterion.getParts().iterator().next();
        }
        String tableName = null;
        Object lValue = criterion.getLValue();
        if (lValue instanceof Column) {
            Column column = (Column)lValue;
            tableName = column.getFullTableName();
        }
        if (tableName == null) {
            throw new TorqueException("Could not determine table name  as first criterion contains no table name");
        }
        return tableName;
    }

    public static TableMap getTableMap(String tableName, String dbName) throws TorqueException {
        DatabaseMap databaseMap;
        if (dbName == null) {
            dbName = Torque.getDefaultDB();
        }
        if ((databaseMap = Torque.getDatabaseMap(dbName)) == null) {
            throw new TorqueException("Could not find database map for database " + dbName);
        }
        String unqualifiedTableName = SqlBuilder.getUnqualifiedName(tableName, dbName);
        TableMap result = databaseMap.getTable(unqualifiedTableName);
        if (result == null) {
            throw new TorqueException("Could not find table " + tableName + " in database map of database " + dbName);
        }
        return result;
    }

    static Column resolveAliasAndAsColumnAndSchema(Column columnToResolve, Criteria criteria) throws TorqueException {
        String resolvedTableName;
        String columnNameToResolve = columnToResolve.getColumnName();
        Column resolvedColumn = criteria.getAsColumns().get(columnNameToResolve);
        boolean sqlExpressionModified = false;
        if (resolvedColumn == null) {
            resolvedColumn = columnToResolve;
        } else {
            sqlExpressionModified = true;
        }
        String tableNameToResolve = resolvedColumn.getTableName();
        Object resolvedAlias = criteria.getAliases().get(tableNameToResolve);
        if (resolvedAlias == null || !(resolvedAlias instanceof String)) {
            resolvedTableName = tableNameToResolve;
        } else {
            resolvedTableName = (String)resolvedAlias;
            sqlExpressionModified = true;
        }
        String resolvedSchemaName = resolvedColumn.getSchemaName();
        if (resolvedSchemaName == null) {
            String dbName = criteria.getDbName();
            Database database = Torque.getDatabase(dbName);
            resolvedSchemaName = database.getSchema();
        }
        if (sqlExpressionModified) {
            return new ColumnImpl(resolvedSchemaName, resolvedTableName, resolvedColumn.getColumnName());
        }
        return new ColumnImpl(resolvedSchemaName, resolvedTableName, resolvedColumn.getColumnName(), resolvedColumn.getSqlExpression());
    }

    static boolean fromClauseContainsExpression(UniqueList<FromElement> fromClause, PreparedStatementPart fromExpression) {
        if (fromExpression == null || fromExpression.getSqlAsString().length() == 0) {
            return false;
        }
        String fromExpressionSql = fromExpression.getSqlAsString();
        for (FromElement fromElement : fromClause) {
            if (!fromExpressionSql.equals(fromElement.getFromExpression())) continue;
            return true;
        }
        return false;
    }

    static void addTableToFromClause(Object possibleColumn, Criteria criteria, Query query) throws TorqueException {
        if (possibleColumn == null || !(possibleColumn instanceof Column)) {
            return;
        }
        Column column = (Column)possibleColumn;
        if (column.getTableName() == null) {
            return;
        }
        PreparedStatementPart fromClauseExpression = SqlBuilder.getExpressionForFromClause(column, criteria);
        UniqueList<FromElement> queryFromClause = query.getFromClause();
        if (!SqlBuilder.fromClauseContainsExpression(queryFromClause, fromClauseExpression)) {
            FromElement fromElement = new FromElement(fromClauseExpression.getSqlAsString(), null, null, fromClauseExpression.getPreparedStatementReplacements());
            queryFromClause.add(fromElement);
        }
    }

    static boolean isIgnoreCase(Criterion criterion, Criteria criteria, Database database) throws TorqueException {
        boolean ignoreCase = criteria.isIgnoreCase() || criterion.isIgnoreCase();
        ignoreCase = ignoreCase && SqlBuilder.ignoreCaseApplicable(criterion.getLValue(), criteria, database) && SqlBuilder.ignoreCaseApplicable(criterion.getRValue(), criteria, database);
        return ignoreCase;
    }

    private static boolean ignoreCaseApplicable(Object value, Criteria criteria, Database database) throws TorqueException {
        if (value == null) {
            return true;
        }
        if (!(value instanceof Column)) {
            return value instanceof String || value instanceof Iterable || value.getClass().isArray();
        }
        Column column = (Column)value;
        Column databaseColumn = SqlBuilder.resolveAliasAndAsColumnAndSchema(column, criteria);
        ColumnMap columnMap = null;
        DatabaseMap databaseMap = database.getDatabaseMap();
        TableMap tableMap = databaseMap.getTable(databaseColumn.getTableName());
        if (tableMap != null) {
            columnMap = tableMap.getColumn(databaseColumn.getColumnName());
        }
        if (columnMap == null) {
            return true;
        }
        return columnMap.getType() instanceof String;
    }

    static {
        whereClausePsPartBuilders.add(new EnumValueBuilder());
        whereClausePsPartBuilders.add(new VerbatimSqlConditionBuilder());
        whereClausePsPartBuilders.add(new CurrentDateTimePsPartBuilder());
        whereClausePsPartBuilders.add(new NullValueBuilder());
        whereClausePsPartBuilders.add(new LikeBuilder());
        whereClausePsPartBuilders.add(new InBuilder());
        whereClausePsPartBuilders.add(new StandardBuilder());
    }
}

