/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import jakarta.servlet.ServletConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.authenticator.SSLAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsRegistry;
import org.apache.openejb.server.webservices.WsServlet;
import org.apache.openejb.util.Strings;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomee.catalina.IgnoredStandardContext;
import org.apache.tomee.catalina.OpenEJBValve;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatWsRegistry
implements WsRegistry {
    private static final String WEBSERVICE_SUB_CONTEXT = Strings.slashify((String[])new String[]{SystemInstance.get().getOptions().get("tomee.jaxws.subcontext", "/webservices")});
    private static final boolean WEBSERVICE_OLDCONTEXT_ACTIVE = SystemInstance.get().getOptions().get("tomee.jaxws.oldsubcontext", false);
    private static final String TOMEE_JAXWS_SECURITY_ROLE_PREFIX = "tomee.jaxws.security-role.";
    private final Map<Key, Context> webserviceContexts = new ConcurrentHashMap<Key, Context>();
    private final Map<String, Integer> fakeContextReferences = new ConcurrentHashMap<String, Integer>();
    private Engine engine;
    private List<Connector> connectors;

    public TomcatWsRegistry() {
        StandardServer standardServer = TomcatHelper.getServer();
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            this.engine = service.getContainer();
            break;
        }
    }

    public List<String> setWsContainer(HttpListener httpListener, ClassLoader classLoader, String contextRoot, String virtualHost, ServletInfo servletInfo, String realmName, String transportGuarantee, String authMethod, String moduleId) throws Exception {
        Context context;
        Container host;
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
        }
        if ("ROOT".equals(contextRoot)) {
            contextRoot = "";
        }
        if (!((String)contextRoot).startsWith("/") && !((String)contextRoot).isEmpty()) {
            contextRoot = "/" + (String)contextRoot;
        }
        if ((context = (Context)host.findChild((String)contextRoot)) == null) {
            throw new IllegalArgumentException("Could not find web application context " + (String)contextRoot + " in host " + host.getName());
        }
        Wrapper wrapper = (Wrapper)context.findChild(servletInfo.servletName);
        if (wrapper == null) {
            throw new IllegalArgumentException("Could not find servlet " + servletInfo.servletName + " in web application context " + context.getName());
        }
        wrapper.setServletClass(WsServlet.class.getName());
        if (wrapper.getServlet() != null) {
            wrapper.unload();
            wrapper.load();
            wrapper.getServlet().init((ServletConfig)StandardWrapper.class.cast(wrapper));
        }
        this.setWsContainer(context, wrapper, httpListener);
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : this.connectors) {
            for (String mapping : servletInfo.mappings) {
                String absoluteMapping = Strings.slashify((String[])new String[]{contextRoot, mapping});
                URI address = new URI(connector.getScheme(), null, host.getName(), connector.getPort(), absoluteMapping, null, null);
                addresses.add(address.toString());
            }
        }
        return addresses;
    }

    public void clearWsContainer(String contextRoot, String virtualHost, ServletInfo servletInfo, String moduleId) {
        Container host;
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
        }
        Context context = (Context)host.findChild("/" + contextRoot);
        if (context == null) {
            throw new IllegalArgumentException("Could not find web application context " + contextRoot + " in host " + host.getName());
        }
        Wrapper wrapper = (Wrapper)context.findChild(servletInfo.servletName);
        if (wrapper == null) {
            throw new IllegalArgumentException("Could not find servlet " + servletInfo.servletName + " in web application context " + context.getName());
        }
        String webServicecontainerId = wrapper.findInitParameter(WsServlet.WEBSERVICE_CONTAINER);
        if (webServicecontainerId != null) {
            context.getServletContext().removeAttribute(webServicecontainerId);
            wrapper.removeInitParameter(WsServlet.WEBSERVICE_CONTAINER);
        }
    }

    public List<String> addWsContainer(HttpListener httpListener, ClassLoader classLoader, String context, String virtualHost, String path, String realmName, String transportGuarantee, String authMethod, String moduleId) throws Exception {
        Container host;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (httpListener == null) {
            throw new NullPointerException("httpListener is null");
        }
        path = Strings.slashify((String[])new String[]{path});
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matchiing Host entry in the server.xml?");
        }
        ArrayList<String> addresses = new ArrayList<String>();
        if (WEBSERVICE_OLDCONTEXT_ACTIVE) {
            this.deployInFakeWebapp(path, classLoader, authMethod, transportGuarantee, realmName, host, httpListener, addresses, context);
        }
        if (context != null) {
            Context webAppContext = this.findContext(context, moduleId, host);
            if (webAppContext != null) {
                this.addServlet(host, webAppContext, Strings.slashify((String[])new String[]{WEBSERVICE_SUB_CONTEXT, path}), httpListener, path, addresses, false, moduleId);
            } else if (!WEBSERVICE_OLDCONTEXT_ACTIVE) {
                this.deployInFakeWebapp(path, classLoader, authMethod, transportGuarantee, realmName, host, httpListener, addresses, context);
            }
        }
        return addresses;
    }

    private Context findContext(String context, String moduleId, Container host) {
        Object root = context;
        if ("ROOT".equals(root)) {
            root = "";
        }
        if (!((String)root).startsWith("/") && !((String)root).isEmpty()) {
            root = "/" + (String)root;
        }
        Context webAppContext = null;
        for (String name : Arrays.asList(moduleId == null ? null : "/" + moduleId, root)) {
            if (name != null && (webAppContext = (Context)Context.class.cast(host.findChild(name))) != null) break;
        }
        return webAppContext;
    }

    private void deployInFakeWebapp(String path, ClassLoader classLoader, String authMethod, String transportGuarantee, String realmName, Container host, HttpListener httpListener, List<String> addresses, String name) {
        Integer ref;
        Container context = host.findChild(name);
        if (context == null) {
            context = TomcatWsRegistry.createNewContext(classLoader, authMethod, transportGuarantee, realmName, name);
            host.addChild(context);
        }
        if ((ref = this.fakeContextReferences.get(name)) == null) {
            this.fakeContextReferences.put(name, 0);
        } else {
            this.fakeContextReferences.put(name, ref + 1);
        }
        this.addServlet(host, (Context)context, Strings.slashify((String[])new String[]{path}), httpListener, path, addresses, true, null);
    }

    private static Context createNewContext(ClassLoader classLoader, String authMethod, String transportGuarantee, String realmName, String name) {
        IgnoredStandardContext context = new IgnoredStandardContext();
        context.setPath(Strings.slashify((String[])new String[]{name}));
        context.setDocBase("");
        context.setParentClassLoader(classLoader);
        context.setDelegate(true);
        context.setName(name);
        ((TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class)).initJ2EEInfo((StandardContext)context);
        if (authMethod != null) {
            authMethod = authMethod.toUpperCase();
        }
        if (transportGuarantee != null) {
            transportGuarantee = transportGuarantee.toUpperCase();
        }
        if (authMethod != null && !"NONE".equals(authMethod)) {
            if ("BASIC".equals(authMethod) || "DIGEST".equals(authMethod) || "CLIENT-CERT".equals(authMethod)) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod(authMethod);
                loginConfig.setRealmName(realmName);
                context.setLoginConfig(loginConfig);
                String securityRole = SystemInstance.get().getProperty(TOMEE_JAXWS_SECURITY_ROLE_PREFIX + name, "default");
                for (String role : securityRole.split(",")) {
                    SecurityCollection collection = new SecurityCollection();
                    collection.addMethod("GET");
                    collection.addMethod("POST");
                    collection.addPattern("/*");
                    collection.setName(role);
                    SecurityConstraint sc = new SecurityConstraint();
                    sc.addAuthRole("*");
                    sc.addCollection(collection);
                    sc.setAuthConstraint(true);
                    sc.setUserConstraint(transportGuarantee);
                    context.addConstraint(sc);
                    context.addSecurityRole(role);
                }
                if ("BASIC".equals(authMethod)) {
                    context.addValve((Valve)new BasicAuthenticator());
                } else if ("DIGEST".equals(authMethod)) {
                    context.addValve((Valve)new DigestAuthenticator());
                } else if ("CLIENT-CERT".equals(authMethod)) {
                    context.addValve((Valve)new SSLAuthenticator());
                } else if ("NONE".equals(authMethod)) {
                    context.addValve((Valve)new NonLoginAuthenticator());
                }
                context.getPipeline().addValve((Valve)new OpenEJBValve());
            } else {
                throw new IllegalArgumentException("Invalid authMethod: " + authMethod);
            }
        }
        return context;
    }

    private void addServlet(Container host, Context context, String mapping, HttpListener httpListener, String path, List<String> addresses, boolean fakeDeployment, String moduleId) {
        Wrapper wrapper = context.createWrapper();
        wrapper.setName("webservice" + path.substring(1));
        wrapper.setServletClass(WsServlet.class.getName());
        context.addChild((Container)wrapper);
        context.addServletMappingDecoded(mapping, wrapper.getName());
        String webServicecontainerID = wrapper.getName() + WsServlet.WEBSERVICE_CONTAINER + httpListener.hashCode();
        wrapper.addInitParameter(WsServlet.WEBSERVICE_CONTAINER, webServicecontainerID);
        this.setWsContainer(context, wrapper, httpListener);
        this.webserviceContexts.put(new Key(path, moduleId), context);
        for (Connector connector : this.connectors) {
            String fullContextPath = !WEBSERVICE_OLDCONTEXT_ACTIVE && !fakeDeployment ? Strings.slashify((String[])new String[]{context.getPath(), WEBSERVICE_SUB_CONTEXT, path}) : Strings.slashify((String[])new String[]{context.getPath(), path});
            try {
                URI address = new URI(connector.getScheme(), null, host.getName(), connector.getPort(), fullContextPath, null, null);
                addresses.add(address.toString());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    public void removeWsContainer(String path, String moduleId) {
        String name;
        if (path == null) {
            return;
        }
        path = Strings.slashify((String[])new String[]{path});
        if (TomcatHelper.isStopping()) {
            return;
        }
        Context context = this.webserviceContexts.remove(new Key(path, moduleId));
        if (context == null) {
            context = this.webserviceContexts.remove(new Key(path, null));
        }
        Integer refs = 1;
        if (context != null && (refs = this.fakeContextReferences.remove(name = context.getName())) != null && refs > 0) {
            this.fakeContextReferences.put(name, refs - 1);
        }
        if ((WEBSERVICE_OLDCONTEXT_ACTIVE || refs != null && refs == 0) && context != null) {
            try {
                context.stop();
                context.destroy();
            }
            catch (Exception e) {
                throw new TomEERuntimeException((Throwable)e);
            }
            Host host = (Host)context.getParent();
            host.removeChild((Container)context);
        }
    }

    private void setWsContainer(Context context, Wrapper wrapper, HttpListener wsContainer) {
        String webServicecontainerID = wrapper.getName() + WsServlet.WEBSERVICE_CONTAINER + wsContainer.hashCode();
        context.getServletContext().setAttribute(webServicecontainerID, (Object)wsContainer);
        wrapper.addInitParameter(WsServlet.WEBSERVICE_CONTAINER, webServicecontainerID);
    }

    private static class Key {
        private final String moduleId;
        private final String path;
        private final int hash;

        public Key(String path, String moduleId) {
            this.moduleId = moduleId;
            this.path = path;
            this.hash = 31 * (moduleId != null ? moduleId.hashCode() : 0) + path.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || Key.class != o.getClass()) {
                return false;
            }
            Key key = (Key)Key.class.cast(o);
            return !(this.moduleId == null ? key.moduleId != null : !this.moduleId.equals(key.moduleId)) && this.path.equals(key.path);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "Key{moduleId='" + this.moduleId + "', path='" + this.path + "'}";
        }
    }
}

