/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class DotNetTranslateVisitor
extends AbstractTranslateVisitor {
    public DotNetTranslateVisitor() {
        this("g");
    }

    public DotNetTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    @Override
    public Void visitTraversalDirection(GremlinParser.TraversalDirectionContext ctx) {
        String direction = ctx.getText().toLowerCase();
        this.sb.append("Direction.");
        if (direction.contains("out")) {
            this.sb.append("Out");
        } else if (direction.contains("in")) {
            this.sb.append("In");
        } else if (direction.contains("from")) {
            this.sb.append("From");
        } else if (direction.contains("to")) {
            this.sb.append("To");
        } else {
            this.sb.append("Both");
        }
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("Double.NaN");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral() != null && ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("Double.NegativeInfinity");
        } else {
            this.sb.append("Double.PositiveInfinity");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        String integerLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = integerLiteral.length() - 1;
        char lastCharacter = integerLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'b': {
                this.sb.append("(sbyte) ");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                break;
            }
            case 's': {
                this.sb.append("(short) ");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                break;
            }
            case 'i': {
                this.sb.append(integerLiteral, 0, lastCharIndex);
                break;
            }
            case 'l': {
                this.sb.append(integerLiteral);
                break;
            }
            case 'n': {
                this.sb.append("BigInteger.Parse(\"");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append("\")");
                break;
            }
            default: {
                this.sb.append(integerLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        if (ctx.infLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.nanLiteral());
        }
        String floatLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = floatLiteral.length() - 1;
        char lastCharacter = floatLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'd': 
            case 'f': {
                this.sb.append(floatLiteral);
                break;
            }
            case 'm': {
                this.sb.append("(decimal) ");
                this.sb.append(floatLiteral, 0, lastCharIndex);
                break;
            }
            default: {
                this.sb.append(floatLiteral);
            }
        }
        return null;
    }

    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(DotNetTranslateVisitor.removeFirstAndLastCharacters(dtString));
        this.sb.append("DateTimeOffset.Parse(\"");
        this.sb.append(dt);
        this.sb.append("\")");
        return null;
    }

    public Void visitGenericRangeLiteral(GremlinParser.GenericRangeLiteralContext ctx) {
        throw new TranslatorException(".NET does not support range literals");
    }

    public Void visitGenericMapLiteral(GremlinParser.GenericMapLiteralContext ctx) {
        this.sb.append("new Dictionary<object, object> {");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("}");
        return null;
    }

    public Void visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        this.sb.append("new HashSet<object> { ");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(" }");
        return null;
    }

    public Void visitGenericCollectionLiteral(GremlinParser.GenericCollectionLiteralContext ctx) {
        this.sb.append("new List<object> { ");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(" }");
        return null;
    }

    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        this.sb.append("{ ");
        this.visit((ParseTree)ctx.mapKey());
        this.sb.append(", ");
        this.visit((ParseTree)ctx.genericLiteral());
        this.sb.append(" }");
        return null;
    }

    public Void visitMapKey(GremlinParser.MapKeyContext ctx) {
        int keyIndex = ctx.LPAREN() != null && ctx.RPAREN() != null ? 1 : 0;
        this.visit(ctx.getChild(keyIndex));
        return null;
    }

    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append("new ").append(ctx.getText()).append("()");
        } else {
            this.sb.append("new ").append(ctx.getChild(0).getText().equals("new") ? ctx.getChild(1).getText() : ctx.getChild(0).getText()).append("(");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            if (configs.size() > 0 && ctx.children.stream().anyMatch(t -> t.getText().equals(OptionsStrategy.class.getSimpleName()))) {
                this.sb.append("new Dictionary<string, object> {");
                for (int ix = 0; ix < configs.size(); ++ix) {
                    this.sb.append("{\"").append(((ParseTree)configs.get(ix)).getChild(0).getText());
                    this.sb.append("\",");
                    this.visit(((ParseTree)configs.get(ix)).getChild(2));
                    this.sb.append("},");
                }
                this.sb.append("}");
            } else {
                for (int ix = 0; ix < configs.size(); ++ix) {
                    this.visit((ParseTree)configs.get(ix));
                    if (ix >= configs.size() - 1) continue;
                    this.sb.append(", ");
                }
            }
            this.sb.append(")");
        }
        return null;
    }

    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        int ix;
        this.sb.append(ctx.getChild(0).getText());
        this.sb.append(": ");
        this.visit(ctx.getChild(2));
        if (ctx.getChild(0).getText().equals("readPartitions")) {
            int ix2 = this.sb.lastIndexOf("List<object>");
            this.sb.replace(ix2, ix2 + 12, "HashSet<string>");
        } else if (ctx.getChild(0).getText().equals("keys") && (ix = this.sb.lastIndexOf("HashSet<object>")) > -1) {
            this.sb.replace(ix, ix + 15, "HashSet<string>");
        }
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_inject(GremlinParser.TraversalSourceSpawnMethod_injectContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalSourceSpawnMethod_io(GremlinParser.TraversalSourceSpawnMethod_ioContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalSourceSpawnMethod_addV(GremlinParser.TraversalSourceSpawnMethod_addVContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        for (int ix = 1; ix < ctx.getChildCount(); ++ix) {
            if (ctx.getChild(ix) instanceof GremlinParser.StringArgumentContext) {
                this.tryAppendCastToString((GremlinParser.StringArgumentContext)ctx.getChild(ix));
            }
            this.visit(ctx.getChild(ix));
        }
        return null;
    }

    public Void visitTraversalMethod_addV_String(GremlinParser.TraversalMethod_addV_StringContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        for (int ix = 1; ix < ctx.getChildCount(); ++ix) {
            if (ctx.getChild(ix) instanceof GremlinParser.StringArgumentContext) {
                this.tryAppendCastToString((GremlinParser.StringArgumentContext)ctx.getChild(ix));
            }
            this.visit(ctx.getChild(ix));
        }
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_addE(GremlinParser.TraversalSourceSpawnMethod_addEContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        for (int ix = 1; ix < ctx.getChildCount(); ++ix) {
            if (ctx.getChild(ix) instanceof GremlinParser.StringArgumentContext) {
                this.tryAppendCastToString((GremlinParser.StringArgumentContext)ctx.getChild(ix));
            }
            this.visit(ctx.getChild(ix));
        }
        return null;
    }

    public Void visitTraversalMethod_addE_String(GremlinParser.TraversalMethod_addE_StringContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        for (int ix = 1; ix < ctx.getChildCount(); ++ix) {
            if (ctx.getChild(ix) instanceof GremlinParser.StringArgumentContext) {
                this.tryAppendCastToString((GremlinParser.StringArgumentContext)ctx.getChild(ix));
            }
            this.visit(ctx.getChild(ix));
        }
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_call_empty(GremlinParser.TraversalSourceSpawnMethod_call_emptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalSourceSpawnMethod_call_string(GremlinParser.TraversalSourceSpawnMethod_call_stringContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("((string) ");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_call_string_map(GremlinParser.TraversalSourceSpawnMethod_call_string_mapContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("(");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(", ");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_call_string_traversal(GremlinParser.TraversalSourceSpawnMethod_call_string_traversalContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("(");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(", ");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_call_string_map_traversal(GremlinParser.TraversalSourceSpawnMethod_call_string_map_traversalContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("(");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(", ");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapArgument());
        this.sb.append(", ");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_mergeV_Map(GremlinParser.TraversalSourceSpawnMethod_mergeV_MapContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapNullableArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_mergeV_Traversal(GremlinParser.TraversalSourceSpawnMethod_mergeV_TraversalContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_mergeE_Map(GremlinParser.TraversalSourceSpawnMethod_mergeE_MapContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapNullableArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_mergeE_Traversal(GremlinParser.TraversalSourceSpawnMethod_mergeE_TraversalContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_union(GremlinParser.TraversalSourceSpawnMethod_unionContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_asString_Scope(GremlinParser.TraversalMethod_asString_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_branch(GremlinParser.TraversalMethod_branchContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_call_string(GremlinParser.TraversalMethod_call_stringContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("((string) ");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_call_string_map(GremlinParser.TraversalMethod_call_string_mapContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("(");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(", ");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_call_string_traversal(GremlinParser.TraversalMethod_call_string_traversalContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("(");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(", ");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_call_string_map_traversal(GremlinParser.TraversalMethod_call_string_map_traversalContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>").append("(");
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(", ");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapArgument());
        this.sb.append(", ");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_cap(GremlinParser.TraversalMethod_capContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_choose_Function(GremlinParser.TraversalMethod_choose_FunctionContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_choose_Predicate_Traversal(GremlinParser.TraversalMethod_choose_Predicate_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_choose_Predicate_Traversal_Traversal(GremlinParser.TraversalMethod_choose_Predicate_Traversal_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_choose_Traversal(GremlinParser.TraversalMethod_choose_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_choose_Traversal_Traversal(GremlinParser.TraversalMethod_choose_Traversal_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_choose_Traversal_Traversal_Traversal(GremlinParser.TraversalMethod_choose_Traversal_Traversal_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_coalesce(GremlinParser.TraversalMethod_coalesceContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_constant(GremlinParser.TraversalMethod_constantContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_elementMap(GremlinParser.TraversalMethod_elementMapContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_flatMap(GremlinParser.TraversalMethod_flatMapContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_fold_Empty(GremlinParser.TraversalMethod_fold_EmptyContext ctx) {
        if (this.isCalledAsFirstStepInAnonymousTraversal((ParseTree)ctx)) {
            return this.handleGenerics((ParseTree)ctx);
        }
        return (Void)super.visitTraversalMethod_fold_Empty(ctx);
    }

    public Void visitTraversalMethod_fold_Object_BiFunction(GremlinParser.TraversalMethod_fold_Object_BiFunctionContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_group_Empty(GremlinParser.TraversalMethod_group_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_groupCount_Empty(GremlinParser.TraversalMethod_groupCount_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_has_String_Object(GremlinParser.TraversalMethod_has_String_ObjectContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.tryAppendCastToString(ctx.stringNullableLiteral());
        this.visit((ParseTree)ctx.stringNullableLiteral());
        this.sb.append(", ");
        this.tryAppendCastToObject(ctx.genericArgument());
        this.visit((ParseTree)ctx.genericArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_has_String_P(GremlinParser.TraversalMethod_has_String_PContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.tryAppendCastToString(ctx.stringNullableLiteral());
        this.visit((ParseTree)ctx.stringNullableLiteral());
        this.sb.append(", ");
        this.visit((ParseTree)ctx.traversalPredicate());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_has_String_String_Object(GremlinParser.TraversalMethod_has_String_String_ObjectContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.tryAppendCastToString(ctx.stringNullableArgument());
        this.visit((ParseTree)ctx.stringNullableArgument());
        this.sb.append(", ");
        this.tryAppendCastToString(ctx.stringNullableLiteral());
        this.visit((ParseTree)ctx.stringNullableLiteral());
        this.sb.append(", ");
        this.tryAppendCastToObject(ctx.genericArgument());
        this.visit((ParseTree)ctx.genericArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_has_String_String_P(GremlinParser.TraversalMethod_has_String_String_PContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.tryAppendCastToString(ctx.stringNullableArgument());
        this.visit((ParseTree)ctx.stringNullableArgument());
        this.sb.append(", ");
        this.tryAppendCastToString(ctx.stringNullableLiteral());
        this.visit((ParseTree)ctx.stringNullableLiteral());
        this.sb.append(", ");
        this.visit((ParseTree)ctx.traversalPredicate());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_has_T_Object(GremlinParser.TraversalMethod_has_T_ObjectContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalT());
        this.sb.append(", ");
        this.tryAppendCastToObject(ctx.genericArgument());
        this.visit((ParseTree)ctx.genericArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_has_T_P(GremlinParser.TraversalMethod_has_T_PContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalT());
        this.sb.append(", ");
        this.visit((ParseTree)ctx.traversalPredicate());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_hasKey_P(GremlinParser.TraversalMethod_hasKey_PContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalPredicate());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_hasKey_String_String(GremlinParser.TraversalMethod_hasKey_String_StringContext ctx) {
        if (ctx.stringNullableLiteralVarargs() == null || ctx.stringNullableLiteralVarargs().getChildCount() == 0) {
            String step = ctx.getChild(0).getText();
            this.sb.append(this.convertToPascalCase(step));
            this.sb.append("(");
            this.tryAppendCastToString(ctx.stringNullableLiteral());
            this.visit((ParseTree)ctx.stringNullableLiteral());
            this.sb.append(")");
            return null;
        }
        return (Void)super.visitTraversalMethod_hasKey_String_String(ctx);
    }

    public Void visitTraversalMethod_hasValue_Object_Object(GremlinParser.TraversalMethod_hasValue_Object_ObjectContext ctx) {
        if (ctx.genericArgumentVarargs() == null || ctx.genericArgumentVarargs().getChildCount() == 0) {
            String step = ctx.getChild(0).getText();
            this.sb.append(this.convertToPascalCase(step));
            this.sb.append("(");
            this.tryAppendCastToObject(ctx.genericArgument());
            this.visit((ParseTree)ctx.genericArgument());
            this.sb.append(")");
            return null;
        }
        return (Void)super.visitTraversalMethod_hasValue_Object_Object(ctx);
    }

    public Void visitTraversalMethod_hasValue_P(GremlinParser.TraversalMethod_hasValue_PContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalPredicate());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_hasLabel_P(GremlinParser.TraversalMethod_hasLabel_PContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalPredicate());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_hasLabel_String_String(GremlinParser.TraversalMethod_hasLabel_String_StringContext ctx) {
        if (ctx.stringNullableArgumentVarargs() == null || ctx.stringNullableArgumentVarargs().getChildCount() == 0) {
            String step = ctx.getChild(0).getText();
            this.sb.append(this.convertToPascalCase(step));
            this.sb.append("(");
            this.tryAppendCastToString(ctx.stringNullableArgument());
            this.visit((ParseTree)ctx.stringNullableArgument());
            this.sb.append(")");
            return null;
        }
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.tryAppendCastToString(ctx.stringNullableArgument());
        this.visit((ParseTree)ctx.stringNullableArgument());
        if (!ctx.stringNullableArgumentVarargs().isEmpty()) {
            this.sb.append(", ");
        }
        this.visit((ParseTree)ctx.stringNullableArgumentVarargs());
        this.sb.append(")");
        return null;
    }

    public Void visitStringNullableArgumentVarargs(GremlinParser.StringNullableArgumentVarargsContext ctx) {
        for (int ix = 0; ix < ctx.getChildCount(); ++ix) {
            ParseTree pt = ctx.getChild(ix);
            if (pt instanceof GremlinParser.StringNullableArgumentContext) {
                GremlinParser.StringNullableArgumentContext sna = (GremlinParser.StringNullableArgumentContext)pt;
                this.tryAppendCastToString(sna);
                this.visit((ParseTree)sna);
                continue;
            }
            this.visit(pt);
        }
        return null;
    }

    public Void visitTraversalMethod_index(GremlinParser.TraversalMethod_indexContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_length_Scope(GremlinParser.TraversalMethod_length_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_limit_Scope_long(GremlinParser.TraversalMethod_limit_Scope_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_limit_long(GremlinParser.TraversalMethod_limit_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_local(GremlinParser.TraversalMethod_localContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_lTrim_Scope(GremlinParser.TraversalMethod_lTrim_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_map(GremlinParser.TraversalMethod_mapContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_match(GremlinParser.TraversalMethod_matchContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_max_Empty(GremlinParser.TraversalMethod_max_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_max_Scope(GremlinParser.TraversalMethod_max_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_mean_Empty(GremlinParser.TraversalMethod_mean_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_mean_Scope(GremlinParser.TraversalMethod_mean_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_mergeV_Map(GremlinParser.TraversalMethod_mergeV_MapContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapNullableArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_mergeV_Traversal(GremlinParser.TraversalMethod_mergeV_TraversalContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_mergeE_Map(GremlinParser.TraversalMethod_mergeE_MapContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapNullableArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_mergeE_Traversal(GremlinParser.TraversalMethod_mergeE_TraversalContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_min_Empty(GremlinParser.TraversalMethod_min_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_min_Scope(GremlinParser.TraversalMethod_min_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_option_Merge_Map(GremlinParser.TraversalMethod_option_Merge_MapContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalMerge());
        this.sb.append(", ");
        this.sb.append("(IDictionary<object, object>) ");
        this.visit((ParseTree)ctx.genericMapNullableArgument());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_option_Object_Traversal(GremlinParser.TraversalMethod_option_Object_TraversalContext ctx) {
        if (ctx.genericArgument().genericLiteral() != null && ctx.genericArgument().genericLiteral().traversalMerge() != null) {
            this.visit(ctx.getChild(0));
            this.sb.append("(");
            this.visit((ParseTree)ctx.genericArgument());
            this.sb.append(", ");
            this.sb.append("(ITraversal) ");
            this.visit((ParseTree)ctx.nestedTraversal());
            this.sb.append(")");
            return null;
        }
        return (Void)super.visitTraversalMethod_option_Object_Traversal(ctx);
    }

    public Void visitTraversalMethod_option_Merge_Traversal(GremlinParser.TraversalMethod_option_Merge_TraversalContext ctx) {
        this.visit(ctx.getChild(0));
        this.sb.append("(");
        this.visit((ParseTree)ctx.traversalMerge());
        this.sb.append(", ");
        this.sb.append("(ITraversal) ");
        this.visit((ParseTree)ctx.nestedTraversal());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_optional(GremlinParser.TraversalMethod_optionalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_profile_Empty(GremlinParser.TraversalMethod_profile_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_project(GremlinParser.TraversalMethod_projectContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_properties(GremlinParser.TraversalMethod_propertiesContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_property_Cardinality_Object_Object_Object(GremlinParser.TraversalMethod_property_Cardinality_Object_Object_ObjectContext ctx) {
        if (ctx.genericArgumentVarargs() == null || ctx.genericArgumentVarargs().getChildCount() == 0) {
            String step = ctx.getChild(0).getText();
            this.sb.append(this.convertToPascalCase(step));
            this.sb.append("(");
            this.visit((ParseTree)ctx.traversalCardinality());
            this.sb.append(", ");
            this.tryAppendCastToObject(ctx.genericLiteral());
            this.visit((ParseTree)ctx.genericLiteral());
            this.sb.append(", ");
            this.tryAppendCastToObject(ctx.genericArgument());
            this.visit((ParseTree)ctx.genericArgument());
            this.sb.append(")");
            return null;
        }
        return (Void)super.visitTraversalMethod_property_Cardinality_Object_Object_Object(ctx);
    }

    public Void visitTraversalMethod_conjoin_String(GremlinParser.TraversalMethod_conjoin_StringContext ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("(");
        this.tryAppendCastToString(ctx.stringLiteral());
        this.visit((ParseTree)ctx.stringLiteral());
        this.sb.append(")");
        return null;
    }

    public Void visitTraversalMethod_propertyMap(GremlinParser.TraversalMethod_propertyMapContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_range_Scope_long_long(GremlinParser.TraversalMethod_range_Scope_long_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_range_long_long(GremlinParser.TraversalMethod_range_long_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_replace_Scope_String_String(GremlinParser.TraversalMethod_replace_Scope_String_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_rTrim_Scope(GremlinParser.TraversalMethod_rTrim_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_sack_Empty(GremlinParser.TraversalMethod_sack_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_Column(GremlinParser.TraversalMethod_select_ColumnContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_Pop_String(GremlinParser.TraversalMethod_select_Pop_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_Pop_String_String_String(GremlinParser.TraversalMethod_select_Pop_String_String_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_Pop_Traversal(GremlinParser.TraversalMethod_select_Pop_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_String(GremlinParser.TraversalMethod_select_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_String_String_String(GremlinParser.TraversalMethod_select_String_String_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_select_Traversal(GremlinParser.TraversalMethod_select_TraversalContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_skip_long(GremlinParser.TraversalMethod_skip_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_skip_Scope_long(GremlinParser.TraversalMethod_skip_Scope_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_split_Scope_String(GremlinParser.TraversalMethod_split_Scope_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_substring_Scope_int(GremlinParser.TraversalMethod_substring_Scope_intContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_substring_Scope_int_int(GremlinParser.TraversalMethod_substring_Scope_int_intContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_sum_Empty(GremlinParser.TraversalMethod_sum_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_sum_Scope(GremlinParser.TraversalMethod_sum_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_tail_Empty(GremlinParser.TraversalMethod_tail_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_tail_Scope(GremlinParser.TraversalMethod_tail_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_tail_Scope_long(GremlinParser.TraversalMethod_tail_Scope_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_tail_long(GremlinParser.TraversalMethod_tail_longContext ctx) {
        return this.handleLongArguments((ParseTree)ctx);
    }

    public Void visitTraversalMethod_toUpper_Scope(GremlinParser.TraversalMethod_toUpper_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_toLower_Scope(GremlinParser.TraversalMethod_toLower_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_tree_Empty(GremlinParser.TraversalMethod_tree_EmptyContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_trim_Scope(GremlinParser.TraversalMethod_trim_ScopeContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_unfold(GremlinParser.TraversalMethod_unfoldContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_union(GremlinParser.TraversalMethod_unionContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_value(GremlinParser.TraversalMethod_valueContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_valueMap_String(GremlinParser.TraversalMethod_valueMap_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_valueMap_boolean_String(GremlinParser.TraversalMethod_valueMap_boolean_StringContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitTraversalMethod_values(GremlinParser.TraversalMethod_valuesContext ctx) {
        return this.handleGenerics((ParseTree)ctx);
    }

    public Void visitClassType(GremlinParser.ClassTypeContext ctx) {
        this.sb.append("typeof(").append(ctx.getText()).append(")");
        return null;
    }

    @Override
    public Void visitUuidLiteral(GremlinParser.UuidLiteralContext ctx) {
        if (ctx.stringLiteral() == null) {
            this.sb.append("Guid.NewGuid()");
            return null;
        }
        this.sb.append("Guid.Parse(");
        this.sb.append(ctx.stringLiteral().getText());
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitTraversalGType(GremlinParser.TraversalGTypeContext ctx) {
        String[] split = ctx.getText().split("\\.");
        this.sb.append(this.processGremlinSymbol(split[0])).append(".");
        this.sb.append(this.processGremlinSymbol(split[1].toLowerCase()));
        return null;
    }

    private Void handleGenerics(ParseTree ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        if (step.equals("group") || step.equals("valueMap")) {
            this.sb.append("<object, object>");
        } else {
            this.sb.append("<object>");
        }
        for (int ix = 1; ix < ctx.getChildCount(); ++ix) {
            this.visit(ctx.getChild(ix));
        }
        return null;
    }

    private Void handleLongArguments(ParseTree ctx) {
        String step = ctx.getChild(0).getText();
        this.sb.append(this.convertToPascalCase(step));
        this.sb.append("<object>");
        for (int ix = 1; ix < ctx.getChildCount(); ++ix) {
            if (ctx.getChild(ix) instanceof GremlinParser.IntegerArgumentContext) {
                this.tryAppendCastToLong((GremlinParser.IntegerArgumentContext)ctx.getChild(ix));
            }
            this.visit(ctx.getChild(ix));
        }
        return null;
    }

    @Override
    protected String processGremlinSymbol(String step) {
        return SymbolHelper.toCSharp(step);
    }

    @Override
    protected void appendExplicitNaming(String txt, String prefix) {
        if (!txt.startsWith(prefix + ".")) {
            this.sb.append(prefix).append(".");
            this.sb.append(this.convertToPascalCase(txt));
        } else {
            String[] split = txt.split("\\.");
            this.sb.append(split[0]).append(".");
            this.sb.append(this.convertToPascalCase(split[1]));
        }
    }

    @Override
    protected String getCardinalityFunctionClass() {
        return "CardinalityValue";
    }

    private void tryAppendCastToLong(GremlinParser.IntegerLiteralContext ctx) {
        if (ctx != null) {
            this.sb.append("(long) ");
        }
    }

    private void tryAppendCastToLong(GremlinParser.IntegerArgumentContext ctx) {
        if (ctx.variable() != null) {
            this.sb.append("(long) ");
        }
    }

    private void tryAppendCastToString(GremlinParser.StringLiteralContext ctx) {
        if (ctx != null) {
            this.sb.append("(string) ");
        }
    }

    private void tryAppendCastToString(GremlinParser.StringArgumentContext ctx) {
        if (ctx.variable() != null) {
            this.sb.append("(string) ");
        }
    }

    private void tryAppendCastToString(GremlinParser.StringNullableArgumentContext ctx) {
        if (ctx.variable() != null || ctx.stringNullableLiteral().K_NULL() != null) {
            this.sb.append("(string) ");
        }
    }

    private void tryAppendCastToString(GremlinParser.StringNullableLiteralContext ctx) {
        if (ctx.K_NULL() != null) {
            this.sb.append("(string) ");
        }
    }

    private void tryAppendCastToObject(GremlinParser.GenericArgumentContext ctx) {
        if (ctx.variable() != null || ctx.genericLiteral().nullLiteral() != null) {
            this.sb.append("(object) ");
        }
    }

    private void tryAppendCastToObject(GremlinParser.GenericLiteralContext ctx) {
        if (ctx.nullLiteral() != null) {
            this.sb.append("(object) ");
        }
    }

    private boolean isCalledAsFirstStepInAnonymousTraversal(ParseTree stepToTest) {
        ParseTree parent = stepToTest.getParent();
        ParseTree parentParent = parent.getParent();
        ParseTree firstStepOfNestedTraversal = parentParent.getChild(0).getChild(0);
        ParseTree parentParentParent = parentParent.getParent();
        return stepToTest == firstStepOfNestedTraversal && parentParentParent instanceof GremlinParser.NestedTraversalContext;
    }

    private String convertToPascalCase(String txt) {
        return txt.substring(0, 1).toUpperCase() + txt.substring(1);
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_CS_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_CS_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toCSharp(String symbol) {
            return TO_CS_MAP.getOrDefault(symbol, StringUtils.capitalize((String)symbol));
        }

        public static String toJava(String symbol) {
            return FROM_CS_MAP.getOrDefault(symbol, StringUtils.uncapitalize((String)symbol));
        }

        static {
            TO_CS_MAP.put("graphml", "GraphML");
            TO_CS_MAP.put("graphson", "GraphSON");
            TO_CS_MAP.put("bigdecimal", "BigDecimal");
            TO_CS_MAP.put("bigint", "BigInt");
            TO_CS_MAP.put("datetime", "DateTime");
            TO_CS_MAP.put("uuid", "UUID");
            TO_CS_MAP.put("vproperty", "VProperty");
            TO_CS_MAP.forEach((k, v) -> FROM_CS_MAP.put((String)v, (String)k));
        }
    }
}

