/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;

final class Rfc3986UriValidator {
    private static final String SCHEME = "(?i)(http|https):";
    private static final String USERINFO = "([^@\\[/?#]*)";
    private static final String HOST = "([^/?#]*)";
    private static final String PATH = "([^?#]*)";
    private static final String QUERY = "([^#]*)";
    private static final String LAST = "#(.*)";
    private static final Pattern HTTP_URL = Pattern.compile("^(?i)(http|https):(//(([^@\\[/?#]*)@)?([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    private Rfc3986UriValidator() {
    }

    public static boolean validate(URI uri) {
        if (HttpUtils.isHttpScheme(uri.getScheme())) {
            Matcher matcher = HTTP_URL.matcher(uri.toString());
            if (matcher.matches()) {
                String host = matcher.group(5);
                return !StringUtils.isEmpty(host);
            }
            return false;
        }
        return true;
    }
}

