/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.audit;

import java.util.List;
import java.util.Map;
import org.apereo.cas.audit.spi.principal.DefaultAuditPrincipalIdProvider;
import org.apereo.cas.authentication.Authentication;
import org.aspectj.lang.JoinPoint;

public class SurrogateAuditPrincipalIdProvider
extends DefaultAuditPrincipalIdProvider {
    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public String getPrincipalIdFrom(JoinPoint auditTarget, Authentication authentication, Object returnValue, Exception exception) {
        if (authentication == null) {
            return "unknown";
        }
        if (this.supports(auditTarget, authentication, returnValue, exception)) {
            Map attributes = authentication.getAttributes();
            String surrogateUser = ((List)attributes.get("surrogateUser")).getFirst().toString();
            String principalId = ((List)attributes.get("surrogatePrincipal")).getFirst().toString();
            return String.format("(Primary User: [%s], Surrogate User: [%s])", principalId, surrogateUser);
        }
        return super.getPrincipalIdFrom(auditTarget, authentication, returnValue, exception);
    }

    public boolean supports(JoinPoint auditTarget, Authentication authentication, Object resultValue, Exception exception) {
        return super.supports(auditTarget, authentication, resultValue, exception) && authentication.containsAttribute("surrogateUser");
    }
}

