/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Process;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class ExecutionListenerValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        this.validateListeners(process, null, process.getExecutionListeners(), errors);
        for (FlowElement flowElement : process.getFlowElements()) {
            this.validateListeners(process, flowElement, flowElement.getExecutionListeners(), errors);
        }
    }

    protected void validateListeners(Process process, FlowElement flowElement, List<FlowableListener> listeners, List<ValidationError> errors) {
        if (listeners != null) {
            for (FlowableListener listener : listeners) {
                if ("script".equals(listener.getImplementationType())) {
                    if (listener.getScriptInfo() != null) continue;
                    this.addError(errors, "flowable-execution-listener-implementation-missing", process, (BaseElement)listener, "executionListener of type 'script' expects a <script> child element.");
                    continue;
                }
                if (listener.getImplementation() != null && listener.getImplementationType() != null) continue;
                this.addError(errors, "flowable-execution-listener-implementation-missing", process, flowElement, (BaseElement)listener, "Element 'class' or 'expression' or type=\"script\" is mandatory on executionListener");
            }
        }
    }
}

