/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class SearchResultsHandlerLoggingProxy
implements SearchResultsHandler {
    private final Log log;
    private final ResultsHandler origHandler;
    private final ConnectorOperationalContext operationalContext;

    public SearchResultsHandlerLoggingProxy(ResultsHandler origHandler, Log log, ConnectorOperationalContext operationalContext) {
        this.origHandler = origHandler;
        this.log = log;
        this.operationalContext = operationalContext;
    }

    public ResultsHandler getOrigHandler() {
        return this.origHandler;
    }

    public void handleResult(SearchResult result) {
        if (this.origHandler instanceof SearchResultsHandler) {
            SpiOperationLoggingUtil.logOpEntry(this.log, this.operationalContext, SearchResultsHandler.class, "handleResult", result);
            try {
                ((SearchResultsHandler)SearchResultsHandler.class.cast(this.origHandler)).handleResult(result);
                SpiOperationLoggingUtil.logOpExit(this.log, this.operationalContext, SearchResultsHandler.class, "handleResult");
            }
            catch (RuntimeException e) {
                SpiOperationLoggingUtil.logOpException(this.log, this.operationalContext, SearchResultsHandler.class, "handleResult", e);
                throw e;
            }
        }
    }

    public boolean handle(ConnectorObject connectorObject) {
        SpiOperationLoggingUtil.logOpEntry(this.log, this.operationalContext, ResultsHandler.class, "handle", connectorObject);
        try {
            boolean ret = this.origHandler.handle(connectorObject);
            SpiOperationLoggingUtil.logOpExit(this.log, this.operationalContext, ResultsHandler.class, "handle", ret);
            return ret;
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(this.log, this.operationalContext, ResultsHandler.class, "handle", e);
            throw e;
        }
    }
}

