/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.saml2.SAML2Response;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;

public class SAML2SP4UIContext
implements WebContext {
    private final String bindingType;
    private final SAML2Response saml2Response;

    public SAML2SP4UIContext(String bindingType, SAML2Response saml2Response) {
        this.bindingType = bindingType;
        this.saml2Response = saml2Response;
    }

    public Optional<String> getQueryString() {
        return Optional.empty();
    }

    public String getRequestMethod() {
        return SAML2BindingType.POST.getUri().equals(this.bindingType) ? "POST" : "GET";
    }

    public Optional<String> getRequestParameter(String name) {
        return switch (name) {
            case "SAMLResponse" -> Optional.ofNullable(this.saml2Response.getSamlResponse());
            case "RelayState" -> Optional.ofNullable(this.saml2Response.getRelayState());
            default -> Optional.empty();
        };
    }

    public Map<String, String[]> getRequestParameters() {
        return Map.of();
    }

    public Optional<String> getRequestAttribute(String name) {
        return Optional.empty();
    }

    public void setRequestAttribute(String name, Object value) {
    }

    public Optional<String> getRequestHeader(String name) {
        return Optional.empty();
    }

    public String getRemoteAddr() {
        return null;
    }

    public void setResponseHeader(String name, String value) {
    }

    public Optional<String> getResponseHeader(String s) {
        return Optional.empty();
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return -1;
    }

    public String getScheme() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public String getFullRequestURL() {
        return null;
    }

    public Collection<Cookie> getRequestCookies() {
        return Set.of();
    }

    public void addResponseCookie(Cookie cookie) {
    }

    public String getPath() {
        return null;
    }

    public void setResponseContentType(String content) {
    }
}

