/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.util.ByteSource;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.credentials.password.ShiroPasswordEncoder;

public class ShiroEncoderBuilder
extends AbstractBuilder {
    public ShiroEncoderBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreatePasswordEncoder(Map<String, PasswordEncoder> encoders) {
        for (int i = 0; i <= 10; ++i) {
            boolean hasProperty;
            String exists = this.getProperty("encoder.shiro", i);
            boolean bl = hasProperty = this.containsProperty("encoder.shiro.generatePublicSalt", i) || this.containsProperty("encoder.shiro.hashAlgorithmName", i) || this.containsProperty("encoder.shiro.hashIterations", i) || this.containsProperty("encoder.shiro.privateSalt", i);
            if (!StringUtils.isNotBlank((CharSequence)exists) && !hasProperty) continue;
            DefaultPasswordService passwordService = new DefaultPasswordService();
            if (hasProperty) {
                DefaultHashService hashService = new DefaultHashService();
                if (this.containsProperty("encoder.shiro.generatePublicSalt", i)) {
                    hashService.setGeneratePublicSalt(this.getPropertyAsBoolean("encoder.shiro.generatePublicSalt", i));
                }
                if (this.containsProperty("encoder.shiro.hashAlgorithmName", i)) {
                    hashService.setHashAlgorithmName(this.getProperty("encoder.shiro.hashAlgorithmName", i));
                }
                if (this.containsProperty("encoder.shiro.hashIterations", i)) {
                    hashService.setHashIterations(this.getPropertyAsInteger("encoder.shiro.hashIterations", i));
                }
                if (this.containsProperty("encoder.shiro.privateSalt", i)) {
                    hashService.setPrivateSalt(ByteSource.Util.bytes((String)this.getProperty("encoder.shiro.privateSalt", i)));
                }
                passwordService.setHashService((HashService)hashService);
            }
            encoders.put(this.concat("encoder.shiro", i), (PasswordEncoder)new ShiroPasswordEncoder((PasswordService)passwordService));
        }
    }
}

