/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import jakarta.annotation.Nonnull;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class CasReloadableMessageBundle
extends ReloadableResourceBundleMessageSource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasReloadableMessageBundle.class);

    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        boolean foundCode;
        if (locale != null && !locale.equals(Locale.ENGLISH) && !(foundCode = this.getBasenameSet().stream().anyMatch(basename -> {
            String filename = basename + "_" + String.valueOf(locale);
            LOGGER.trace("Examining bundle [{}] for the key [{}]", (Object)filename, (Object)code);
            ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filename);
            return holder.getProperties() != null && holder.getProperty(code) != null;
        }))) {
            LOGGER.trace("The key [{}] cannot be found in the bundle for the locale [{}]", (Object)code, (Object)locale);
        }
        return super.getMessageInternal(code, args, locale);
    }

    protected String getDefaultMessage(@Nonnull String code) {
        String messageToReturn = super.getDefaultMessage(code);
        if (StringUtils.isNotBlank((CharSequence)messageToReturn) && messageToReturn.equals(code)) {
            LOGGER.trace("The code [{}] cannot be found in the default language bundle and will be used as the message itself.", (Object)code);
        }
        return messageToReturn;
    }
}

