/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.okta.authn.sdk.client.AuthenticationClient;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.okta.OktaAuthenticationProperties;
import org.apereo.cas.okta.OktaAuthenticationHandler;
import org.apereo.cas.okta.OktaConfigurationFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="okta")
@Configuration(value="OktaAuthenticationConfiguration", proxyBeanMethods=false)
class OktaAuthenticationConfiguration {
    OktaAuthenticationConfiguration() {
    }

    @Configuration(value="OktaAuthenticationCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OktaAuthenticationCoreConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.okta.organization-url");

        OktaAuthenticationCoreConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oktaAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer oktaAuthenticationEventExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="oktaAuthenticationHandler") AuthenticationHandler oktaAuthenticationHandler) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(oktaAuthenticationHandler, defaultPrincipalResolver)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oktaPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory oktaPrincipalFactory(ConfigurableApplicationContext applicationContext) {
            return (PrincipalFactory)BeanSupplier.of(PrincipalFactory.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(PrincipalFactoryUtils::newPrincipalFactory).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oktaAuthenticationHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationHandler oktaAuthenticationHandler(@Qualifier(value="oktaPrincipalFactory") PrincipalFactory oktaPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="oktaAuthenticationClient") AuthenticationClient oktaAuthenticationClient, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (AuthenticationHandler)BeanSupplier.of(AuthenticationHandler.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                OktaAuthenticationProperties okta = casProperties.getAuthn().getOkta();
                OktaAuthenticationHandler handler = new OktaAuthenticationHandler(okta.getName(), servicesManager, oktaPrincipalFactory, okta, oktaAuthenticationClient);
                handler.setState(okta.getState());
                handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)okta.getPrincipalTransformation()));
                handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)okta.getPasswordEncoder(), (ApplicationContext)applicationContext));
                handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)okta.getCredentialCriteria()));
                return handler;
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"oktaAuthenticationClient"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationClient oktaAuthenticationClient(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (AuthenticationClient)BeanSupplier.of(AuthenticationClient.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                OktaAuthenticationProperties properties = casProperties.getAuthn().getOkta();
                return OktaConfigurationFactory.buildAuthenticationClient(properties);
            }).otherwiseProxy().get();
        }
    }
}

