/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.apache.syncope.common.keymaster.client.api.DomainWatcher;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.common.keymaster.client.api.model.Neo4jDomain;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.keymaster.DomainDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.keymaster.DomainEntity;
import org.springframework.security.access.prepost.PreAuthorize;

public class DomainLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final DomainDAO domainDAO;
    protected final EntityFactory entityFactory;
    protected final DomainWatcher domainWatcher;

    public DomainLogic(DomainDAO domainDAO, EntityFactory entityFactory, DomainWatcher domainWatcher) {
        this.domainDAO = domainDAO;
        this.entityFactory = entityFactory;
        this.domainWatcher = domainWatcher;
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public List<Domain> list() {
        return this.domainDAO.findAll().stream().map(DomainEntity::get).toList();
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public Domain read(String key) {
        DomainEntity domain = (DomainEntity)this.domainDAO.findById(key).orElseThrow(() -> new NotFoundException("Domain " + key));
        return domain.get();
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public Domain create(Domain domain) {
        if (Objects.equals(domain.getKey(), "Master")) {
            throw new KeymasterException("Cannot create domain Master");
        }
        if (this.domainDAO.existsById(domain.getKey())) {
            throw new DuplicateException("Domain " + domain.getKey() + " already existing");
        }
        DomainEntity domainEntity = (DomainEntity)this.entityFactory.newEntity(DomainEntity.class);
        domainEntity.setKey(domain.getKey());
        domainEntity.set(domain);
        domainEntity = (DomainEntity)this.domainDAO.save((Entity)domainEntity);
        this.domainWatcher.added(domain);
        return domainEntity.get();
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void deployed(String key) {
        DomainEntity domain = (DomainEntity)this.domainDAO.findById(key).orElseThrow(() -> new NotFoundException("Domain " + key));
        Domain domainObj = domain.get();
        domainObj.setDeployed(true);
        domain.set(domainObj);
        this.domainDAO.save((Entity)domain);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void changeAdminPassword(String key, String password, CipherAlgorithm cipherAlgorithm) {
        DomainEntity domain = (DomainEntity)this.domainDAO.findById(key).orElseThrow(() -> new NotFoundException("Domain " + key));
        Domain domainObj = domain.get();
        domainObj.setAdminPassword(password);
        domainObj.setAdminCipherAlgorithm(cipherAlgorithm);
        domain.set(domainObj);
        this.domainDAO.save((Entity)domain);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void adjustPoolSize(String key, int poolMaxActive, int poolMinIdle) {
        Domain domain;
        DomainEntity domainEntity = (DomainEntity)this.domainDAO.findById(key).orElseThrow(() -> new NotFoundException("Domain " + key));
        Domain domain2 = domain = domainEntity.get();
        Objects.requireNonNull(domain2);
        Domain domain3 = domain2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JPADomain.class, Neo4jDomain.class}, (Object)domain3, n)) {
            case 0: {
                JPADomain jpaDomain = (JPADomain)domain3;
                jpaDomain.setPoolMaxActive(poolMaxActive);
                jpaDomain.setPoolMinIdle(poolMinIdle);
                break;
            }
            case 1: {
                Neo4jDomain neo4jDomain = (Neo4jDomain)domain3;
                neo4jDomain.setMaxConnectionPoolSize(poolMaxActive);
                break;
            }
        }
        domainEntity.set(domain);
        this.domainDAO.save((Entity)domainEntity);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void delete(String key) {
        this.domainDAO.deleteById(key);
        this.domainWatcher.removed(key);
    }

    protected EntityTO resolveReference(Method method, Object ... args) {
        throw new UnsupportedOperationException();
    }
}

