/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delete;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delete.BatchDeleteProcessConfig;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DeleteHistoricProcessInstancesSequentialJobHandler
implements JobHandler {
    public static final String TYPE = "delete-historic-processes-sequential";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchDeleteProcessConfig config = BatchDeleteProcessConfig.create(configuration, engineConfiguration);
        BatchPart batchPart = config.getBatchPart();
        Batch batch = config.getBatch();
        if (config.hasError()) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, config.getError());
            return;
        }
        if ("stopped".equals(batch.getStatus())) {
            batchService.completeBatchPart(batchPart.getId(), "stopped", null);
            return;
        }
        int batchSize = config.getBatchSize();
        HistoricProcessInstanceQuery query = config.getQuery();
        List historicProcessInstances = query.withoutSorting().returnIdsOnly().listPage(0, batchSize);
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        HashSet<String> processInstanceIdsToDelete = new HashSet<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            processInstanceIdsToDelete.add(historicProcessInstance.getId());
        }
        if (processInstanceIdsToDelete.isEmpty()) {
            batchService.completeBatchPart(batchPart.getId(), "completed", resultNode.toString());
            this.completeBatch(batch, "completed", engineConfiguration);
            return;
        }
        String status = "completed";
        HistoryService historyService = engineConfiguration.getHistoryService();
        try {
            historyService.bulkDeleteHistoricProcessInstances(processInstanceIdsToDelete);
            ArrayNode deletedProcessInstanceIdsNode = resultNode.withArray("processInstanceIdsDeleted");
            processInstanceIdsToDelete.forEach(arg_0 -> ((ArrayNode)deletedProcessInstanceIdsNode).add(arg_0));
        }
        catch (FlowableException ex) {
            status = "failed";
            ArrayNode processInstanceIdsFailedToDelete = resultNode.withArray("processInstanceIdsFailedToDelete");
            processInstanceIdsToDelete.forEach(arg_0 -> ((ArrayNode)processInstanceIdsFailedToDelete).add(arg_0));
            resultNode.put("error", ex.getMessage());
            resultNode.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)ex));
        }
        batchService.completeBatchPart(batchPart.getId(), status, resultNode.toString());
        if ("failed".equals(status)) {
            this.completeBatch(batch, "failed", engineConfiguration);
        } else {
            BatchPart nextBatchPart = engineConfiguration.getManagementService().createBatchPartBuilder(batch).type("deleteProcess").searchKey(String.valueOf(Integer.parseInt(batchPart.getSearchKey()) + 1)).status("waiting").create();
            JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
            JobEntity nextJob = jobService.createJob();
            nextJob.setJobHandlerType(TYPE);
            nextJob.setJobHandlerConfiguration(nextBatchPart.getId());
            jobService.createAsyncJob(nextJob, false);
            jobService.scheduleAsyncJob(nextJob);
        }
    }

    protected void failBatchPart(ProcessEngineConfigurationImpl engineConfiguration, BatchService batchService, BatchPart batchPart, Batch batch, String resultJson) {
        batchService.completeBatchPart(batchPart.getId(), "failed", resultJson);
        this.completeBatch(batch, "failed", engineConfiguration);
    }

    protected void completeBatch(Batch batch, String status, ProcessEngineConfigurationImpl engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }
}

