/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.JacksonCodecs;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataObject {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataObject.class);
    private static final ObjectMapper OBJECT_MAPPER = JacksonCodecs.json();
    private static final TypeReference<Map<String, String>> MAP_STRING_STRING_TYPE = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<List<String>> LIST_STRING_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<List<JsonNode>> LIST_JSONNODE_TYPE = new TypeReference<List<JsonNode>>(){};
    private final JsonNode data;
    private final String identifier;
    private final long version;
    private final Map<String, String> vendorInfo;
    private final List<String> trustedCertificates;
    private final List<JsonNode> devices;

    @JsonCreator
    public MetadataObject(JsonNode data) {
        this.data = data;
        try {
            this.vendorInfo = (Map)OBJECT_MAPPER.readValue(data.get("vendorInfo").traverse(), MAP_STRING_STRING_TYPE);
            this.trustedCertificates = (List)OBJECT_MAPPER.readValue(data.get("trustedCertificates").traverse(), LIST_STRING_TYPE);
            this.devices = (List)OBJECT_MAPPER.readValue(data.get("devices").traverse(), LIST_JSONNODE_TYPE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON data", e);
        }
        this.identifier = data.get("identifier").asText();
        this.version = data.get("version").asLong();
    }

    public static MetadataObject readDefault() {
        return MetadataObject.readMetadata("/metadata.json");
    }

    public static MetadataObject readPreview() {
        return MetadataObject.readMetadata("/preview-metadata.json");
    }

    public static MetadataObject readMetadata(String path) {
        return (MetadataObject)FunctionUtils.doUnchecked(() -> {
            try (InputStream is = MetadataObject.class.getResourceAsStream(path);){
                MetadataObject metadataObject = MetadataObject.readMetadata(is);
                return metadataObject;
            }
        });
    }

    public static MetadataObject readMetadata(InputStream is) {
        try {
            return (MetadataObject)JacksonCodecs.json().readValue(is, MetadataObject.class);
        }
        catch (IOException e) {
            throw ExceptionUtil.wrapAndLog((Logger)LOGGER, (String)"Failed to read default metadata", (Throwable)e);
        }
    }

    @JsonIgnore
    public List<X509Certificate> getParsedTrustedCertificates() throws CertificateException {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (String trustedCertificate : this.trustedCertificates) {
            X509Certificate x509Certificate = CertificateParser.parsePem((String)trustedCertificate);
            list.add(x509Certificate);
        }
        return list;
    }

    public List<JsonNode> getDevices() {
        return (List)MoreObjects.firstNonNull(this.devices, List.of());
    }

    @Generated
    public JsonNode getData() {
        return this.data;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, String> getVendorInfo() {
        return this.vendorInfo;
    }

    @Generated
    public List<String> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataObject)) {
            return false;
        }
        MetadataObject other = (MetadataObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonNode this$data = this.data;
        JsonNode other$data = other.data;
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetadataObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonNode $data = this.data;
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

