/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;

public class SystemMonitorHealthIndicator
extends AbstractHealthIndicator {
    private final ObjectProvider<MetricsEndpoint> metrics;
    private final int threshold;

    protected void doHealthCheck(Health.Builder builder) {
        double systemLoad = this.getMetricsFor("system.load.average.1m");
        builder.withDetail("systemUsage", (Object)this.getMetricsFor("system.cpu.usage")).withDetail("systemLoad", (Object)this.getMetricsFor("system.load.average.1m")).withDetail("processUsage", (Object)this.getMetricsFor("process.cpu.usage")).withDetail("jvmUsed", (Object)this.getMetricsFor("jvm.memory.used")).withDetail("jvmCommitted", (Object)this.getMetricsFor("jvm.memory.committed")).withDetail("heapUsed", (Object)this.getMetricsFor("jvm.memory.used", List.of("area:heap"))).withDetail("heapCommitted", (Object)this.getMetricsFor("jvm.memory.committed", List.of("area:heap"))).withDetail("uptime", (Object)this.getMetricsFor("process.uptime")).withDetail("requests", (Object)this.getMetricsFor("http.server.requests")).withDetail("maxRequest", (Object)this.getMetricsFor("http.server.requests", 2));
        if (systemLoad > (double)this.threshold) {
            builder.status("WARN");
        } else {
            builder.status(Status.UP);
        }
    }

    private double getMetricsFor(String key) {
        return this.getMetricsFor(key, null, 0);
    }

    private double getMetricsFor(String key, int measure) {
        return this.getMetricsFor(key, null, measure);
    }

    private double getMetricsFor(String key, List<String> tag) {
        return this.getMetricsFor(key, tag, 0);
    }

    private double getMetricsFor(String key, List<String> tag, int measure) {
        return Optional.ofNullable((MetricsEndpoint)this.metrics.getIfAvailable()).map(endpoint -> {
            MetricsEndpoint.MetricDescriptor metric = endpoint.metric(key, tag);
            List measures = Optional.ofNullable(metric).map(MetricsEndpoint.MetricDescriptor::getMeasurements).orElse(null);
            return measures != null ? ((MetricsEndpoint.Sample)measures.get(measure)).getValue() : 0.0;
        }).orElse(0.0);
    }

    @Generated
    public SystemMonitorHealthIndicator(ObjectProvider<MetricsEndpoint> metrics, int threshold) {
        this.metrics = metrics;
        this.threshold = threshold;
    }
}

