/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AbstractQueryPersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;

public class MappablePersonAttributeDao
extends AbstractQueryPersonAttributeDao<String> {
    private Map<String, Map<String, List<Object>>> backingMap = new HashMap<String, Map<String, List<Object>>>();
    private Set<String> possibleUserAttributeNames = new HashSet<String>();
    private String queryAttributeName;

    public void setBackingMap(Map<String, Map<String, List<Object>>> backingMap) {
        this.backingMap = new LinkedHashMap<String, Map<String, List<Object>>>(backingMap);
        this.initializePossibleAttributeNames();
    }

    public Set<String> getPossibleUserAttributeNames(PersonAttributeDaoFilter filter) {
        return Set.copyOf(this.possibleUserAttributeNames);
    }

    public Set<String> getAvailableQueryAttributes(PersonAttributeDaoFilter filter) {
        UsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        String usernameAttribute = usernameAttributeProvider.getUsernameAttribute();
        HashSet<String> list = new HashSet<String>();
        list.add(usernameAttribute);
        return list;
    }

    protected String appendAttributeToQuery(String queryBuilder, String dataAttribute, List<Object> queryValues) {
        String keyAttributeName;
        if (queryBuilder != null) {
            return queryBuilder;
        }
        String string = keyAttributeName = this.queryAttributeName != null ? this.queryAttributeName : this.getUsernameAttributeProvider().getUsernameAttribute();
        if (keyAttributeName.equals(dataAttribute)) {
            return String.valueOf(queryValues.getFirst());
        }
        return null;
    }

    protected List<PersonAttributes> getPeopleForQuery(String seedValue, String queryUserName) {
        if (seedValue != null && seedValue.contains("*")) {
            Pattern seedPattern = this.compilePattern(seedValue);
            ArrayList<PersonAttributes> results = new ArrayList<PersonAttributes>();
            for (Map.Entry<String, Map<String, List<Object>>> attributesEntry : this.backingMap.entrySet()) {
                Map<String, List<Object>> attributes;
                String attributesKey = attributesEntry.getKey();
                Matcher keyMatcher = seedPattern.matcher(attributesKey);
                if (!keyMatcher.matches() || (attributes = attributesEntry.getValue()) == null) continue;
                PersonAttributes person = this.createPerson(null, queryUserName, attributes);
                results.add(person);
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        Map<String, List<Object>> attributes = this.backingMap.get(seedValue);
        if (attributes == null) {
            return null;
        }
        PersonAttributes person = this.createPerson(seedValue, queryUserName, attributes);
        ArrayList<PersonAttributes> list = new ArrayList<PersonAttributes>();
        list.add(person);
        return list;
    }

    private PersonAttributes createPerson(String seedValue, String queryUserName, Map<String, List<Object>> attributes) {
        String userNameAttribute = this.getConfiguredUserNameAttribute();
        if (this.isUserNameAttributeConfigured() && attributes.containsKey(userNameAttribute)) {
            return SimplePersonAttributes.fromAttribute((String)userNameAttribute, attributes);
        }
        if (queryUserName != null) {
            return new SimplePersonAttributes(queryUserName, attributes);
        }
        if (seedValue != null && userNameAttribute.equals(this.queryAttributeName)) {
            return new SimplePersonAttributes(seedValue, attributes);
        }
        return SimplePersonAttributes.fromAttribute((String)userNameAttribute, attributes);
    }

    private void initializePossibleAttributeNames() {
        this.possibleUserAttributeNames = this.backingMap.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Generated
    public Map<String, Map<String, List<Object>>> getBackingMap() {
        return this.backingMap;
    }

    @Generated
    public String getQueryAttributeName() {
        return this.queryAttributeName;
    }
}

