/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;

public class LogEvent
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LogEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    @Nonnull
    private Set<String> suppressedEvents = CollectionSupport.emptySet();

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.checkSetterPreconditions();
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setSuppressedEvents(@Nullable Collection<String> events) {
        this.checkSetterPreconditions();
        this.suppressedEvents = events != null ? new HashSet<String>(StringSupport.normalizeStringCollection(events)) : CollectionSupport.emptySet();
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String eventString;
        Object event;
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        Object object = event = eventCtx != null ? eventCtx.getEvent() : null;
        if (event != null && !this.suppressedEvents.contains(eventString = event.toString())) {
            this.log.warn("A non-proceed event occurred while processing the request: {}", (Object)eventString);
        }
    }
}

