/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;

public class DirectCasProxyClient
extends DirectClient {
    private CasConfiguration configuration;
    private UrlResolver urlResolver = new DefaultUrlResolver();
    private CallbackUrlResolver callbackUrlResolver = new NoParameterCallbackUrlResolver();
    private String serviceUrl;

    public DirectCasProxyClient() {
    }

    public DirectCasProxyClient(CasConfiguration casConfiguration, String serviceUrl) {
        this.configuration = casConfiguration;
        this.serviceUrl = serviceUrl;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"serviceUrl", (String)this.serviceUrl);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CasProtocol protocol = this.configuration.getProtocol();
        CommonHelper.assertTrue((protocol == CasProtocol.CAS20_PROXY || protocol == CasProtocol.CAS30_PROXY ? 1 : 0) != 0, (String)"The DirectCasProxyClient must be configured with a CAS proxy protocol (CAS20_PROXY or CAS30_PROXY)");
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new ParameterExtractor("ticket", true, false));
        this.setAuthenticatorIfUndefined(new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, this.serviceUrl, this.findSessionLogoutHandler()));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DirectCasProxyClient setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DirectCasProxyClient setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DirectCasProxyClient setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DirectCasProxyClient setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DirectCasProxyClient(super=" + super.toString() + ", configuration=" + this.configuration + ", urlResolver=" + this.urlResolver + ", callbackUrlResolver=" + this.callbackUrlResolver + ", serviceUrl=" + this.serviceUrl + ")";
    }
}

