/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.logout.SessionTerminationHandler;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedProfileTerminationHandler
implements SessionTerminationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedProfileTerminationHandler.class);

    public List<? extends Serializable> beforeSessionTermination(RequestContext requestContext) {
        LOGGER.trace("Destroying application session...");
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        JEEContext context = new JEEContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context, (SessionStore)new JEESessionStore());
        manager.removeProfiles();
        HttpSession session = request.getSession(false);
        String url = (String)FunctionUtils.doIfNotNull((Object)session, () -> (String)session.getAttribute("pac4jRequestedUrl"));
        return (List)FunctionUtils.doIfNotNull((Object)url, () -> List.of(new Pac4jRequestedUrl(url)), List::of).get();
    }

    public void afterSessionTermination(List<? extends Serializable> terminationResults, RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        terminationResults.stream().filter(Pac4jRequestedUrl.class::isInstance).map(Pac4jRequestedUrl.class::cast).filter(req -> StringUtils.isNotBlank((CharSequence)req.url())).forEach(req -> request.getSession(true).setAttribute("pac4jRequestedUrl", (Object)req.url()));
    }

    private record Pac4jRequestedUrl(String url) implements Serializable
    {
    }
}

