/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.org;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.org.OrgContactTypeObjList;
import com.okta.sdk.resource.org.OrgContactUser;
import com.okta.sdk.resource.org.OrgOktaCommunicationSetting;
import com.okta.sdk.resource.org.OrgOktaSupportSettingsObj;
import com.okta.sdk.resource.org.OrgPreferences;
import com.okta.sdk.resource.org.OrgSetting;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultOrgSetting
extends AbstractInstanceResource<OrgSetting>
implements OrgSetting {
    private static final StringProperty address1Property = new StringProperty("address1");
    private static final StringProperty address2Property = new StringProperty("address2");
    private static final StringProperty cityProperty = new StringProperty("city");
    private static final StringProperty companyNameProperty = new StringProperty("companyName");
    private static final StringProperty countryProperty = new StringProperty("country");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty endUserSupportHelpURLProperty = new StringProperty("endUserSupportHelpURL");
    private static final DateProperty expiresAtProperty = new DateProperty("expiresAt");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty phoneNumberProperty = new StringProperty("phoneNumber");
    private static final StringProperty postalCodeProperty = new StringProperty("postalCode");
    private static final StringProperty stateProperty = new StringProperty("state");
    private static final StringProperty statusProperty = new StringProperty("status");
    private static final StringProperty subdomainProperty = new StringProperty("subdomain");
    private static final StringProperty supportPhoneNumberProperty = new StringProperty("supportPhoneNumber");
    private static final StringProperty websiteProperty = new StringProperty("website");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultOrgSetting.createPropertyDescriptorMap(address1Property, address2Property, cityProperty, companyNameProperty, countryProperty, createdProperty, endUserSupportHelpURLProperty, expiresAtProperty, idProperty, lastUpdatedProperty, phoneNumberProperty, postalCodeProperty, stateProperty, statusProperty, subdomainProperty, supportPhoneNumberProperty, websiteProperty);

    public DefaultOrgSetting(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultOrgSetting(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return OrgSetting.class;
    }

    public String getAddress1() {
        return this.getString(address1Property);
    }

    public OrgSetting setAddress1(String address1) {
        this.setProperty(address1Property, (Object)address1);
        return this;
    }

    public String getAddress2() {
        return this.getString(address2Property);
    }

    public OrgSetting setAddress2(String address2) {
        this.setProperty(address2Property, (Object)address2);
        return this;
    }

    public String getCity() {
        return this.getString(cityProperty);
    }

    public OrgSetting setCity(String city) {
        this.setProperty(cityProperty, (Object)city);
        return this;
    }

    public String getCompanyName() {
        return this.getString(companyNameProperty);
    }

    public OrgSetting setCompanyName(String companyName) {
        this.setProperty(companyNameProperty, (Object)companyName);
        return this;
    }

    public String getCountry() {
        return this.getString(countryProperty);
    }

    public OrgSetting setCountry(String country) {
        this.setProperty(countryProperty, (Object)country);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getEndUserSupportHelpURL() {
        return this.getString(endUserSupportHelpURLProperty);
    }

    public OrgSetting setEndUserSupportHelpURL(String endUserSupportHelpURL) {
        this.setProperty(endUserSupportHelpURLProperty, (Object)endUserSupportHelpURL);
        return this;
    }

    public Date getExpiresAt() {
        return this.getDateProperty(expiresAtProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getPhoneNumber() {
        return this.getString(phoneNumberProperty);
    }

    public OrgSetting setPhoneNumber(String phoneNumber) {
        this.setProperty(phoneNumberProperty, (Object)phoneNumber);
        return this;
    }

    public String getPostalCode() {
        return this.getString(postalCodeProperty);
    }

    public OrgSetting setPostalCode(String postalCode) {
        this.setProperty(postalCodeProperty, (Object)postalCode);
        return this;
    }

    public String getState() {
        return this.getString(stateProperty);
    }

    public OrgSetting setState(String state) {
        this.setProperty(stateProperty, (Object)state);
        return this;
    }

    public String getStatus() {
        return this.getString(statusProperty);
    }

    public String getSubdomain() {
        return this.getString(subdomainProperty);
    }

    public String getSupportPhoneNumber() {
        return this.getString(supportPhoneNumberProperty);
    }

    public OrgSetting setSupportPhoneNumber(String supportPhoneNumber) {
        this.setProperty(supportPhoneNumberProperty, (Object)supportPhoneNumber);
        return this;
    }

    public String getWebsite() {
        return this.getString(websiteProperty);
    }

    public OrgSetting setWebsite(String website) {
        this.setProperty(websiteProperty, (Object)website);
        return this;
    }

    public OrgSetting partialUpdate() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        DefaultOrgSetting orgSetting = this;
        this.getDataStore().create("/api/v1/org", this, this, OrgSetting.class, queryArgs, (Map<String, List<String>>)headers);
        return orgSetting;
    }

    public OrgOktaSupportSettingsObj getSupportSettings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/privacy/oktaSupport", OrgOktaSupportSettingsObj.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgContactUser getOrgContactUser(String contactType) {
        Assert.hasText((String)contactType, (String)"'contactType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/contacts/" + contactType + "", OrgContactUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgPreferences orgPreferences() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/preferences", OrgPreferences.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void updateOrgLogo(File file) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");
        this.getDataStore().create("/api/v1/org/logo", new DefaultFileResource(this.getDataStore(), file.getAbsoluteFile().toPath(), "file"), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgContactTypeObjList getContactTypes() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/contacts", OrgContactTypeObjList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaCommunicationSetting communicationSettings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/privacy/oktaCommunication", OrgOktaCommunicationSetting.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgPreferences hideFooter() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/preferences/hideEndUserFooter", new DefaultVoidResource(this.getDataStore()), this, OrgPreferences.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgSetting update() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/org";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public OrgPreferences showFooter() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/preferences/showEndUserFooter", new DefaultVoidResource(this.getDataStore()), this, OrgPreferences.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

