/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class X509WebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509WebflowConfigurer.class);

    public X509WebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getX509().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState actionState = this.createActionState(flow, "startX509Authenticate", new String[]{"x509Check"});
            TransitionSet transitionSet = actionState.getTransitionSet();
            Pair<String, String> targetStates = this.getTargetStates(flow);
            transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
            transitionSet.add(this.createTransition("warn", "warn"));
            transitionSet.add(this.createTransition("error", this.getStateIdOnX509Failure(flow, targetStates)));
            transitionSet.add(this.createTransition("authenticationFailure", "handleAuthenticationFailure"));
            transitionSet.add(this.createTransition("successWithWarnings", "showAuthenticationWarningMessages"));
            actionState.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
            ActionState initState = (ActionState)this.getState(flow, (String)targetStates.getLeft(), ActionState.class);
            this.createTransitionForState((TransitionableState)initState, (String)targetStates.getRight(), "startX509Authenticate", true);
        }
    }

    private String getStateIdOnX509Failure(Flow flow, Pair<String, String> targetStates) {
        ActionState state = (ActionState)this.getState(flow, (String)targetStates.getLeft(), ActionState.class);
        return state.getTransition((String)targetStates.getRight()).getTargetStateId();
    }

    protected Pair<String, String> getTargetStates(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
        if (state.getTransition("passwordlessGetUserId") != null) {
            LOGGER.debug("Attaching X509 flow to passwordless flow");
            return new ImmutablePair((Object)"initializeLoginForm", (Object)"passwordlessGetUserId");
        }
        LOGGER.debug("Attaching X509 flow to regular login flow");
        return Pair.of((Object)"afterInitializeLoginForm", (Object)"success");
    }
}

