/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.fido.metadata.AuthenticatorStatus;
import com.yubico.fido.metadata.CertFromBase64Converter;
import com.yubico.fido.metadata.CertToBase64Converter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=StatusReportBuilder.class)
public final class StatusReport {
    @NonNull
    private final AuthenticatorStatus status;
    private final LocalDate effectiveDate;
    private final Long authenticatorVersion;
    @JsonDeserialize(converter=CertFromBase64Converter.class)
    @JsonSerialize(converter=CertToBase64Converter.class)
    private final X509Certificate certificate;
    @JsonProperty(value="url")
    private final String url;
    private final String certificationDescriptor;
    private final String certificateNumber;
    private final String certificationPolicyVersion;
    private final String certificationRequirementsVersion;

    public Optional<LocalDate> getEffectiveDate() {
        return Optional.ofNullable(this.effectiveDate);
    }

    public Optional<Long> getAuthenticatorVersion() {
        return Optional.ofNullable(this.authenticatorVersion);
    }

    @JsonIgnore
    public Optional<X509Certificate> getCertificate() {
        return Optional.ofNullable(this.certificate);
    }

    public Optional<URL> getUrl() {
        try {
            return Optional.of(new URL(this.url));
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
    }

    @JsonIgnore
    public Optional<String> getUrlAsString() {
        return Optional.ofNullable(this.url);
    }

    public Optional<String> getCertificationDescriptor() {
        return Optional.ofNullable(this.certificationDescriptor);
    }

    public Optional<String> getCertificateNumber() {
        return Optional.ofNullable(this.certificateNumber);
    }

    public Optional<String> getCertificationPolicyVersion() {
        return Optional.ofNullable(this.certificationPolicyVersion);
    }

    public Optional<String> getCertificationRequirementsVersion() {
        return Optional.ofNullable(this.certificationRequirementsVersion);
    }

    @Generated
    public static StatusReportBuilder builder() {
        return new StatusReportBuilder();
    }

    @NonNull
    @Generated
    public AuthenticatorStatus getStatus() {
        return this.status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusReport)) {
            return false;
        }
        StatusReport other = (StatusReport)o;
        Optional<Long> this$authenticatorVersion = this.getAuthenticatorVersion();
        Optional<Long> other$authenticatorVersion = other.getAuthenticatorVersion();
        if (this$authenticatorVersion == null ? other$authenticatorVersion != null : !((Object)this$authenticatorVersion).equals(other$authenticatorVersion)) {
            return false;
        }
        AuthenticatorStatus this$status = this.getStatus();
        AuthenticatorStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Optional<LocalDate> this$effectiveDate = this.getEffectiveDate();
        Optional<LocalDate> other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        Optional<X509Certificate> this$certificate = this.getCertificate();
        Optional<X509Certificate> other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        Optional<URL> this$url = this.getUrl();
        Optional<URL> other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        Optional<String> this$certificationDescriptor = this.getCertificationDescriptor();
        Optional<String> other$certificationDescriptor = other.getCertificationDescriptor();
        if (this$certificationDescriptor == null ? other$certificationDescriptor != null : !((Object)this$certificationDescriptor).equals(other$certificationDescriptor)) {
            return false;
        }
        Optional<String> this$certificateNumber = this.getCertificateNumber();
        Optional<String> other$certificateNumber = other.getCertificateNumber();
        if (this$certificateNumber == null ? other$certificateNumber != null : !((Object)this$certificateNumber).equals(other$certificateNumber)) {
            return false;
        }
        Optional<String> this$certificationPolicyVersion = this.getCertificationPolicyVersion();
        Optional<String> other$certificationPolicyVersion = other.getCertificationPolicyVersion();
        if (this$certificationPolicyVersion == null ? other$certificationPolicyVersion != null : !((Object)this$certificationPolicyVersion).equals(other$certificationPolicyVersion)) {
            return false;
        }
        Optional<String> this$certificationRequirementsVersion = this.getCertificationRequirementsVersion();
        Optional<String> other$certificationRequirementsVersion = other.getCertificationRequirementsVersion();
        return !(this$certificationRequirementsVersion == null ? other$certificationRequirementsVersion != null : !((Object)this$certificationRequirementsVersion).equals(other$certificationRequirementsVersion));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Long> $authenticatorVersion = this.getAuthenticatorVersion();
        result = result * 59 + ($authenticatorVersion == null ? 43 : ((Object)$authenticatorVersion).hashCode());
        AuthenticatorStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Optional<LocalDate> $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        Optional<X509Certificate> $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        Optional<URL> $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        Optional<String> $certificationDescriptor = this.getCertificationDescriptor();
        result = result * 59 + ($certificationDescriptor == null ? 43 : ((Object)$certificationDescriptor).hashCode());
        Optional<String> $certificateNumber = this.getCertificateNumber();
        result = result * 59 + ($certificateNumber == null ? 43 : ((Object)$certificateNumber).hashCode());
        Optional<String> $certificationPolicyVersion = this.getCertificationPolicyVersion();
        result = result * 59 + ($certificationPolicyVersion == null ? 43 : ((Object)$certificationPolicyVersion).hashCode());
        Optional<String> $certificationRequirementsVersion = this.getCertificationRequirementsVersion();
        result = result * 59 + ($certificationRequirementsVersion == null ? 43 : ((Object)$certificationRequirementsVersion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatusReport(status=" + (Object)((Object)this.getStatus()) + ", effectiveDate=" + this.getEffectiveDate() + ", authenticatorVersion=" + this.getAuthenticatorVersion() + ", certificate=" + this.getCertificate() + ", url=" + this.getUrl() + ", certificationDescriptor=" + this.getCertificationDescriptor() + ", certificateNumber=" + this.getCertificateNumber() + ", certificationPolicyVersion=" + this.getCertificationPolicyVersion() + ", certificationRequirementsVersion=" + this.getCertificationRequirementsVersion() + ")";
    }

    @Generated
    private StatusReport(@NonNull AuthenticatorStatus status, LocalDate effectiveDate, Long authenticatorVersion, X509Certificate certificate, String url, String certificationDescriptor, String certificateNumber, String certificationPolicyVersion, String certificationRequirementsVersion) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.status = status;
        this.effectiveDate = effectiveDate;
        this.authenticatorVersion = authenticatorVersion;
        this.certificate = certificate;
        this.url = url;
        this.certificationDescriptor = certificationDescriptor;
        this.certificateNumber = certificateNumber;
        this.certificationPolicyVersion = certificationPolicyVersion;
        this.certificationRequirementsVersion = certificationRequirementsVersion;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class StatusReportBuilder {
        @Generated
        private AuthenticatorStatus status;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private Long authenticatorVersion;
        @Generated
        private X509Certificate certificate;
        @Generated
        private String url;
        @Generated
        private String certificationDescriptor;
        @Generated
        private String certificateNumber;
        @Generated
        private String certificationPolicyVersion;
        @Generated
        private String certificationRequirementsVersion;

        @Generated
        StatusReportBuilder() {
        }

        @Generated
        public StatusReportBuilder status(@NonNull AuthenticatorStatus status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
            return this;
        }

        @Generated
        public StatusReportBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public StatusReportBuilder authenticatorVersion(Long authenticatorVersion) {
            this.authenticatorVersion = authenticatorVersion;
            return this;
        }

        @JsonDeserialize(converter=CertFromBase64Converter.class)
        @Generated
        public StatusReportBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        @JsonProperty(value="url")
        @Generated
        public StatusReportBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public StatusReportBuilder certificationDescriptor(String certificationDescriptor) {
            this.certificationDescriptor = certificationDescriptor;
            return this;
        }

        @Generated
        public StatusReportBuilder certificateNumber(String certificateNumber) {
            this.certificateNumber = certificateNumber;
            return this;
        }

        @Generated
        public StatusReportBuilder certificationPolicyVersion(String certificationPolicyVersion) {
            this.certificationPolicyVersion = certificationPolicyVersion;
            return this;
        }

        @Generated
        public StatusReportBuilder certificationRequirementsVersion(String certificationRequirementsVersion) {
            this.certificationRequirementsVersion = certificationRequirementsVersion;
            return this;
        }

        @Generated
        public StatusReport build() {
            return new StatusReport(this.status, this.effectiveDate, this.authenticatorVersion, this.certificate, this.url, this.certificationDescriptor, this.certificateNumber, this.certificationPolicyVersion, this.certificationRequirementsVersion);
        }

        @Generated
        public String toString() {
            return "StatusReport.StatusReportBuilder(status=" + (Object)((Object)this.status) + ", effectiveDate=" + this.effectiveDate + ", authenticatorVersion=" + this.authenticatorVersion + ", certificate=" + this.certificate + ", url=" + this.url + ", certificationDescriptor=" + this.certificationDescriptor + ", certificateNumber=" + this.certificateNumber + ", certificationPolicyVersion=" + this.certificationPolicyVersion + ", certificationRequirementsVersion=" + this.certificationRequirementsVersion + ")";
        }
    }
}

