/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.scim;

import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Optional;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMGeneralConf;
import org.apache.syncope.common.lib.scim.SCIMItem;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.logic.SchemaLogic;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;

public class SCIMConfManager {
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMConfManager.class);
    protected final ConfParamOps confParamOps;
    protected final SchemaLogic schemaLogic;

    public SCIMConfManager(ConfParamOps confParamOps, SchemaLogic schemaLogic) {
        this.confParamOps = confParamOps;
        this.schemaLogic = schemaLogic;
    }

    @PreAuthorize(value="hasRole('SCIM_CONF_GET')")
    public SCIMConf get() {
        return Optional.ofNullable((String)this.confParamOps.get(AuthContextUtils.getDomain(), "scimv2.conf", null, String.class)).map(confString -> {
            try {
                return (SCIMConf)POJOHelper.deserialize((String)new String(Base64.getDecoder().decode((String)confString)), SCIMConf.class);
            }
            catch (Exception e) {
                LOG.error("Could not deserialize, reverting to default", (Throwable)e);
                return null;
            }
        }).orElseGet(() -> {
            SCIMConf scimConf = new SCIMConf();
            this.set(scimConf);
            return scimConf;
        });
    }

    @PreAuthorize(value="hasRole('SCIM_CONF_SET')")
    public void set(SCIMConf conf) {
        try {
            this.schemaLogic.read(SchemaType.PLAIN, "scimv2.conf");
        }
        catch (NotFoundException e) {
            PlainSchemaTO scimConf = new PlainSchemaTO();
            scimConf.setKey("scimv2.conf");
            scimConf.setType(AttrSchemaType.Binary);
            scimConf.setMimeType("application/json");
            this.schemaLogic.create(SchemaType.PLAIN, (SchemaTO)scimConf);
        }
        if (conf.getGeneralConf() == null) {
            conf.setGeneralConf(new SCIMGeneralConf());
        }
        conf.getGeneralConf().setLastChangeDate(OffsetDateTime.now());
        if (conf.getExtensionUserConf() != null) {
            conf.getExtensionUserConf().getAttributes().forEach(this::checkSCIMItem);
        }
        if (conf.getExtensionGroupConf() != null) {
            conf.getExtensionGroupConf().getAttributes().forEach(this::checkSCIMItem);
        }
        if (!conf.getExtensionAnyObjectsConf().isEmpty()) {
            conf.getExtensionAnyObjectsConf().forEach(confItem -> {
                if (confItem != null) {
                    confItem.getAttributes().forEach(this::checkSCIMItem);
                }
            });
        }
        this.confParamOps.set(AuthContextUtils.getDomain(), "scimv2.conf", (Object)Base64.getEncoder().encodeToString(POJOHelper.serialize((Object)conf).getBytes()));
    }

    private void checkSCIMItem(SCIMItem scimItem) {
        block7: {
            try {
                PlainSchemaTO schema = (PlainSchemaTO)this.schemaLogic.read(SchemaType.PLAIN, scimItem.getExtAttrName());
                SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
                if (!scimItem.getMandatoryCondition().equals(schema.getMandatoryCondition())) {
                    invalidMapping.getElements().add("'" + scimItem.getIntAttrName() + "' should " + (Boolean.parseBoolean(schema.getMandatoryCondition()) ? "" : "not") + " be required");
                }
                if (scimItem.isMultiValued() != schema.isMultivalue()) {
                    invalidMapping.getElements().add("'" + scimItem.getIntAttrName() + "' should " + (schema.isMultivalue() ? "" : "not") + " be multi-value");
                }
                if (scimItem.isMutability() != schema.isReadonly()) {
                    invalidMapping.getElements().add("'" + scimItem.getIntAttrName() + "' should " + (schema.isReadonly() ? "" : "not") + " be readonly");
                }
                if (scimItem.isUniqueness() != schema.isUniqueConstraint()) {
                    invalidMapping.getElements().add("'" + scimItem.getIntAttrName() + "' should " + (schema.isUniqueConstraint() ? "" : "not") + " be unique");
                }
                if (!invalidMapping.getElements().isEmpty()) {
                    throw invalidMapping;
                }
            }
            catch (NotFoundException e) {
                PlainSchemaTO schema = (PlainSchemaTO)this.schemaLogic.read(SchemaType.VIRTUAL, scimItem.getExtAttrName());
                if (scimItem.isMutability() == schema.isReadonly()) break block7;
                SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
                invalidMapping.getElements().add("'" + scimItem.getIntAttrName() + "' should " + (schema.isReadonly() ? "" : "not") + " be readonly");
                throw invalidMapping;
            }
        }
    }
}

