/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.identityconnectors.common.Assertions;

public final class Version
implements Comparable<Version> {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)(\\.(\\d+))?(\\.(\\d+))?(\\.(\\d+))?(-\\w+)?");
    private static final int[] GROUPS = new int[]{1, 3, 5, 7};
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int MICRO = 2;
    private static final int REVISION = 3;
    private static final int MAX_COMPONENTS = 4;
    private final Integer[] components;

    public static Version parse(String version) {
        return new Version(Version.parseInternal(version));
    }

    public static Version create(Integer ... components) {
        return new Version(components);
    }

    private static Integer[] parseInternal(String version) {
        Assertions.nullCheck(version, "version");
        Matcher matcher = PATTERN.matcher(version.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Invalid version number %s", version));
        }
        ArrayList<Integer> components = new ArrayList<Integer>(4);
        for (int group : GROUPS) {
            String text = matcher.group(group);
            if (text == null || text.startsWith("-")) continue;
            try {
                components.add(Integer.valueOf(text));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Non-numeric version component %s", text));
            }
        }
        return components.toArray(new Integer[components.size()]);
    }

    Version(Integer ... components) {
        Assertions.nullCheck(components, "components");
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != null && components[i] >= 0) continue;
            throw new IllegalArgumentException("Illegal version number");
        }
        if (components.length == 0) {
            throw new IllegalArgumentException("Too few version components");
        }
        if (components.length > 4) {
            throw new IllegalArgumentException("Too many version components");
        }
        this.components = new Integer[components.length];
        System.arraycopy(components, 0, this.components, 0, components.length);
    }

    public Integer getMajor() {
        return this.getComponent(0);
    }

    public Integer getMinor() {
        return this.getComponent(1);
    }

    public Integer getMicro() {
        return this.getComponent(2);
    }

    public Integer getRevision() {
        return this.getComponent(3);
    }

    private Integer getComponent(int index) {
        return index < this.components.length ? this.components[index] : null;
    }

    public String getVersion() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    public int hashCode() {
        int result = 12345;
        for (int i = 0; i < this.components.length; ++i) {
            result ^= (this.components[i] != null ? this.components[i] : 0) << i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Version) {
            return this.compareTo((Version)o) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Version that) {
        for (int i = 0; i < Math.max(this.components.length, that.components.length); ++i) {
            Integer c2;
            Integer c1 = i < this.components.length ? this.components[i] : Integer.valueOf(0);
            int result = c1.compareTo(c2 = i < that.components.length ? that.components[i] : Integer.valueOf(0));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Version[");
        this.appendTo(builder);
        builder.append(']');
        return builder.toString();
    }

    private void appendTo(StringBuilder builder) {
        for (int i = 0; i < this.components.length; ++i) {
            builder.append(this.components[i]);
            if (i >= this.components.length - 1) continue;
            builder.append('.');
        }
    }
}

