/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotEmpty;

public class NotEmptyCheck
extends AbstractAnnotationCheck<NotEmpty> {
    private static final long serialVersionUID = 1L;

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Collection) {
            return !((Collection)valueToValidate).isEmpty();
        }
        if (valueToValidate instanceof Map) {
            return !((Map)valueToValidate).isEmpty();
        }
        if (valueToValidate.getClass().isArray()) {
            return Array.getLength(valueToValidate) > 0;
        }
        return valueToValidate.toString().length() > 0;
    }
}

