/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.markup;

import com.day.cq.commons.DiffInfo;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.InplaceEditingConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.sling.commons.request.RequestParam;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MediaMarkupBuilderUtil {
    private MediaMarkupBuilderUtil() {
    }

    @Deprecated
    public static void addDiffDecoration(@NotNull HtmlElement<?> mediaElement, @NotNull Resource resource, @NotNull String refProperty, @NotNull SlingHttpServletRequest request) {
        MediaMarkupBuilderUtil.addDiffDecoration(mediaElement, resource, refProperty, request, null);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void addDiffDecoration(@NotNull HtmlElement<?> mediaElement, @NotNull Resource resource, @NotNull String refProperty, @NotNull SlingHttpServletRequest request, @Nullable MediaHandlerConfig mediaHandlerConfig) {
        PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
        Page currentPage = pageManager.getContainingPage(request.getResource());
        Page resourcePage = pageManager.getContainingPage(resource);
        String versionLabel = RequestParam.get((ServletRequest)request, (String)"cq_diffTo");
        if (StringUtils.isNotEmpty((CharSequence)versionLabel) && currentPage != null && currentPage.equals(resourcePage)) {
            Resource versionedResource = DiffInfo.getVersionedResource((Resource)resource, (String)versionLabel);
            if (versionedResource != null) {
                String oldMediaRef;
                ValueMap currentProperties = resource.getValueMap();
                ValueMap oldProperties = versionedResource.getValueMap();
                String currentMediaRef = (String)currentProperties.get(refProperty, String.class);
                if (!StringUtils.equals((CharSequence)currentMediaRef, (CharSequence)(oldMediaRef = (String)oldProperties.get(refProperty, String.class)))) {
                    if (StringUtils.isEmpty((CharSequence)currentMediaRef)) {
                        mediaElement.addCssClass("wcmio_mediahandler_wcm_diff_removed");
                    } else if (StringUtils.isEmpty((CharSequence)oldMediaRef)) {
                        mediaElement.addCssClass("wcmio_mediahandler_wcm_diff_added");
                    } else {
                        mediaElement.addCssClass("wcmio_mediahandler_wcm_diff_updated");
                    }
                } else {
                    String oldMediaCrop;
                    String cropProperty = mediaHandlerConfig != null ? mediaHandlerConfig.getMediaCropProperty() : "mediaCrop";
                    String currentMediaCrop = (String)currentProperties.get(cropProperty, String.class);
                    if (!StringUtils.equals((CharSequence)currentMediaCrop, (CharSequence)(oldMediaCrop = (String)oldProperties.get(cropProperty, String.class)))) {
                        mediaElement.addCssClass("wcmio_mediahandler_wcm_diff_updated");
                    }
                }
            } else {
                mediaElement.addCssClass("wcmio_mediahandler_wcm_diff_added");
            }
        }
    }

    @NotNull
    public static Dimension getMediaformatDimension(@NotNull Media media) {
        MediaFormat firstMediaFormat;
        Dimension dimension;
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        long width = mediaArgs.getFixedWidth();
        long height = mediaArgs.getFixedHeight();
        if ((width == 0L || height == 0L) && mediaFormats != null && mediaFormats.length > 0 && (dimension = (firstMediaFormat = mediaArgs.getMediaFormats()[0]).getMinDimension()) != null) {
            width = dimension.getWidth();
            height = dimension.getHeight();
        }
        if (width == 0L) {
            width = 30L;
        }
        if (height == 0L) {
            height = 30L;
        }
        return new Dimension(width, height);
    }

    public static boolean canApplyDragDropSupport(@NotNull MediaRequest mediaRequest, @Nullable ComponentContext wcmComponentContext) {
        switch (mediaRequest.getMediaArgs().getDragDropSupport()) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case AUTO: {
                String resourcePath = null;
                Resource mediaRequestResource = mediaRequest.getResource();
                if (mediaRequestResource != null) {
                    resourcePath = mediaRequestResource.getPath();
                }
                String componentResourcePath = null;
                if (wcmComponentContext != null && wcmComponentContext.getResource() != null) {
                    componentResourcePath = wcmComponentContext.getResource().getPath();
                }
                return resourcePath != null && StringUtils.equals((CharSequence)resourcePath, componentResourcePath);
            }
        }
        throw new IllegalArgumentException("Unsupported drag&drop support mode: " + (Object)((Object)mediaRequest.getMediaArgs().getDragDropSupport()));
    }

    public static boolean canSetCustomIPECropRatios(@NotNull MediaRequest mediaRequest, @Nullable ComponentContext wcmComponentContext) {
        EditConfig editConfig = null;
        InplaceEditingConfig ipeConfig = null;
        if (wcmComponentContext != null && wcmComponentContext.getEditContext() != null && wcmComponentContext.getEditContext().getEditConfig() != null && wcmComponentContext.getResource() != null) {
            editConfig = wcmComponentContext.getEditContext().getEditConfig();
            ipeConfig = editConfig.getInplaceEditingConfig();
        }
        if (editConfig == null || ipeConfig == null || !StringUtils.equals((CharSequence)ipeConfig.getEditorType(), (CharSequence)"image")) {
            return false;
        }
        switch (mediaRequest.getMediaArgs().getIPERatioCustomize()) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case AUTO: {
                if (StringUtils.isNotEmpty((CharSequence)ipeConfig.getConfigPath())) {
                    String ratiosPath = ipeConfig.getConfigPath() + "/plugins/crop/aspectRatios";
                    ResourceResolver resolver = wcmComponentContext.getResource().getResourceResolver();
                    return resolver.getResource(ratiosPath) == null;
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported IPE ratio customize mode: " + (Object)((Object)mediaRequest.getMediaArgs().getIPERatioCustomize()));
    }
}

