/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.refresh;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.http.client.common.AbstractAddressManager;
import org.apache.servicecomb.http.client.common.URLEndPoint;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;

public class ServiceRegistryAddressManager
extends AbstractAddressManager {
    private static final String URI_PREFIX = "rest://";
    private static final String ZONE = "availableZone";
    private static final String REGION = "region";

    public ServiceRegistryAddressManager(List<String> addresses, String ownRegion, String ownAvailableZone, EventBus eventBus) {
        super(addresses, ownRegion, ownAvailableZone);
        eventBus.register((Object)this);
    }

    public IpPort getAvailableIpPort() {
        return this.transformIpPort(this.address());
    }

    protected String normalizeUri(String endpoint) {
        return new URIEndpointObject(endpoint).toString();
    }

    public IpPort transformIpPort(String address) {
        URI uri = URI.create(URI_PREFIX + address);
        return new IpPort(uri.getHost(), uri.getPort());
    }

    @Subscribe
    public void onRefreshEndpointEvent(RefreshEndpointEvent event) {
        this.refreshEndpoint(event, "SERVICECENTER");
    }

    public void constructAffinityAddress(List<String> addresses, String ownRegion, String ownAvailableZone) {
        boolean isAffinityAddress = addresses.stream().anyMatch(addr -> addr.contains(ZONE) || addr.contains(REGION));
        if (!isAffinityAddress || StringUtils.isEmpty((CharSequence)ownRegion) && StringUtils.isEmpty((CharSequence)ownAvailableZone)) {
            return;
        }
        HashSet<String> sameZone = new HashSet<String>();
        HashSet<String> sameRegion = new HashSet<String>();
        for (String address : addresses) {
            URI uri = URI.create(address);
            String ipPort = NetUtils.parseIpPort((URI)uri).toString();
            if (this.isMatchRegionAndZone(address, ownRegion, ownAvailableZone)) {
                sameZone.add(ipPort);
                continue;
            }
            sameRegion.add(ipPort);
        }
        this.refreshAffinityAddress(sameZone, sameRegion);
    }

    private boolean isMatchRegionAndZone(String address, String ownRegion, String ownAvailableZone) {
        try {
            URLEndPoint endPoint = new URLEndPoint(address);
            if (!StringUtils.equals((CharSequence)ownRegion, (CharSequence)endPoint.getFirst(REGION))) {
                return false;
            }
            return StringUtils.equals((CharSequence)ownAvailableZone, (CharSequence)endPoint.getFirst(ZONE));
        }
        catch (Exception e) {
            return false;
        }
    }
}

