/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import java.security.AccessController;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadHelper.class);
    private static final Spinner SPINNER;

    public static void onSpinWait() {
        SPINNER.onSpinWait();
    }

    private ThreadHelper() {
    }

    private static Spinner createSpinner() {
        String superClassName = Spinner.class.getName();
        String superClassNameInternal = superClassName.replace('.', '/');
        String spinnerClassName = superClassName + "Impl";
        String spinnerClassNameInternal = spinnerClassName.replace('.', '/');
        String threadClassNameInternal = Thread.class.getName().replace('.', '/');
        ClassWriter cw = new ClassWriter(1);
        cw.visit(196653, 33, spinnerClassNameInternal, null, superClassNameInternal, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClassNameInternal, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(129, "onSpinWait", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, threadClassNameInternal, "onSpinWait", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        try {
            byte[] classBytes = cw.toByteArray();
            Class<?> spinnerClass = SpinnerClassLoader.INSTANCE.defineClass(spinnerClassName, classBytes);
            return (Spinner)spinnerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            LOG.warn("Error constructing spinner class: {}, will return a default spinner.", (Object)spinnerClassName, (Object)t);
            return new DefaultSpinner();
        }
    }

    static {
        Object maybeException = AccessController.doPrivileged(() -> {
            try {
                Thread.class.getDeclaredMethod("onSpinWait", new Class[0]);
                return null;
            }
            catch (NoSuchMethodException | SecurityException e) {
                return e;
            }
        });
        SPINNER = maybeException == null ? ThreadHelper.createSpinner() : new DefaultSpinner();
    }

    private static class SpinnerClassLoader
    extends ClassLoader {
        static final SpinnerClassLoader INSTANCE;

        SpinnerClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<?> defineClass(String name, byte[] bytes) throws ClassFormatError {
            return this.defineClass(name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
        }

        static {
            ClassLoader parent = Spinner.class.getClassLoader();
            if (parent == null) {
                parent = ClassLoader.getSystemClassLoader();
            }
            INSTANCE = new SpinnerClassLoader(parent);
        }
    }

    static class DefaultSpinner
    extends Spinner {
        DefaultSpinner() {
        }

        @Override
        public void onSpinWait() {
            Thread.yield();
        }
    }

    public static abstract class Spinner {
        public abstract void onSpinWait();
    }
}

