/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging.codec;

import org.apache.qpid.server.protocol.v1_0.DeserializationFactories;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractCompositeTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public final class TargetConstructor
extends AbstractCompositeTypeConstructor<Target> {
    private static final TargetConstructor INSTANCE = new TargetConstructor();

    public static void register(DescribedTypeConstructorRegistry registry) {
        registry.register(Symbol.valueOf("amqp:target:list"), INSTANCE);
        registry.register(UnsignedLong.valueOf(41L), INSTANCE);
    }

    @Override
    protected String getTypeName() {
        return Target.class.getSimpleName();
    }

    @Override
    protected Target construct(AbstractCompositeTypeConstructor.FieldValueReader fieldValueReader) throws AmqpErrorException {
        Symbol[] capabilities;
        Object dynamicNodeProperties;
        Boolean dynamic;
        UnsignedInteger timeout;
        Object expiryPolicy;
        Object durable;
        Target obj = new Target();
        String address = fieldValueReader.readValue(0, "address", false, String.class);
        if (address != null) {
            obj.setAddress(address);
        }
        if ((durable = fieldValueReader.readValue(1, "durable", false, Object.class)) != null) {
            try {
                obj.setDurable(TerminusDurability.valueOf(durable));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'durable' of 'Target'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((expiryPolicy = fieldValueReader.readValue(2, "expiryPolicy", false, Object.class)) != null) {
            try {
                obj.setExpiryPolicy(TerminusExpiryPolicy.valueOf(expiryPolicy));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'expiryPolicy' of 'Target'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((timeout = fieldValueReader.readValue(3, "timeout", false, UnsignedInteger.class)) != null) {
            obj.setTimeout(timeout);
        }
        if ((dynamic = fieldValueReader.readValue(4, "dynamic", false, Boolean.class)) != null) {
            obj.setDynamic(dynamic);
        }
        if ((dynamicNodeProperties = fieldValueReader.readValue(5, "dynamicNodeProperties", false, Object.class)) != null) {
            try {
                obj.setDynamicNodeProperties(DeserializationFactories.convertToNodeProperties(dynamicNodeProperties));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'dynamicNodeProperties' of 'Target'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((capabilities = fieldValueReader.readArrayValue(6, "capabilities", false, Symbol.class, x -> (Symbol)x)) != null) {
            obj.setCapabilities(capabilities);
        }
        return obj;
    }
}

