/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReplyOrConfirmationConfirmation extends ReplyOrConfirmation implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final Confirmation confirmation;
  protected final ReplyOrConfirmation embeddedReply;

  // Arguments.
  protected final CBusOptions cBusOptions;
  protected final RequestContext requestContext;

  public ReplyOrConfirmationConfirmation(
      byte peekedByte,
      Confirmation confirmation,
      ReplyOrConfirmation embeddedReply,
      CBusOptions cBusOptions,
      RequestContext requestContext) {
    super(peekedByte, cBusOptions, requestContext);
    this.confirmation = confirmation;
    this.embeddedReply = embeddedReply;
    this.cBusOptions = cBusOptions;
    this.requestContext = requestContext;
  }

  public Confirmation getConfirmation() {
    return confirmation;
  }

  public ReplyOrConfirmation getEmbeddedReply() {
    return embeddedReply;
  }

  @Override
  protected void serializeReplyOrConfirmationChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReplyOrConfirmationConfirmation");

    // Simple Field (confirmation)
    writeSimpleField("confirmation", confirmation, writeComplex(writeBuffer));

    // Optional Field (embeddedReply) (Can be skipped, if the value is null)
    writeOptionalField("embeddedReply", embeddedReply, writeComplex(writeBuffer));

    writeBuffer.popContext("ReplyOrConfirmationConfirmation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReplyOrConfirmationConfirmation _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (confirmation)
    lengthInBits += confirmation.getLengthInBits();

    // Optional Field (embeddedReply)
    if (embeddedReply != null) {
      lengthInBits += embeddedReply.getLengthInBits();
    }

    return lengthInBits;
  }

  public static ReplyOrConfirmationBuilder staticParseReplyOrConfirmationBuilder(
      ReadBuffer readBuffer, CBusOptions cBusOptions, RequestContext requestContext)
      throws ParseException {
    readBuffer.pullContext("ReplyOrConfirmationConfirmation");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Confirmation confirmation =
        readSimpleField(
            "confirmation", readComplex(() -> Confirmation.staticParse(readBuffer), readBuffer));

    ReplyOrConfirmation embeddedReply =
        readOptionalField(
            "embeddedReply",
            readComplex(
                () ->
                    ReplyOrConfirmation.staticParse(
                        readBuffer, (CBusOptions) (cBusOptions), (RequestContext) (requestContext)),
                readBuffer));

    readBuffer.closeContext("ReplyOrConfirmationConfirmation");
    // Create the instance
    return new ReplyOrConfirmationConfirmationBuilderImpl(
        confirmation, embeddedReply, cBusOptions, requestContext);
  }

  public static class ReplyOrConfirmationConfirmationBuilderImpl
      implements ReplyOrConfirmation.ReplyOrConfirmationBuilder {
    private final Confirmation confirmation;
    private final ReplyOrConfirmation embeddedReply;
    private final CBusOptions cBusOptions;
    private final RequestContext requestContext;

    public ReplyOrConfirmationConfirmationBuilderImpl(
        Confirmation confirmation,
        ReplyOrConfirmation embeddedReply,
        CBusOptions cBusOptions,
        RequestContext requestContext) {
      this.confirmation = confirmation;
      this.embeddedReply = embeddedReply;
      this.cBusOptions = cBusOptions;
      this.requestContext = requestContext;
    }

    public ReplyOrConfirmationConfirmation build(
        byte peekedByte, CBusOptions cBusOptions, RequestContext requestContext) {
      ReplyOrConfirmationConfirmation replyOrConfirmationConfirmation =
          new ReplyOrConfirmationConfirmation(
              peekedByte, confirmation, embeddedReply, cBusOptions, requestContext);
      return replyOrConfirmationConfirmation;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReplyOrConfirmationConfirmation)) {
      return false;
    }
    ReplyOrConfirmationConfirmation that = (ReplyOrConfirmationConfirmation) o;
    return (getConfirmation() == that.getConfirmation())
        && (getEmbeddedReply() == that.getEmbeddedReply())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getConfirmation(), getEmbeddedReply());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
