/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcRecord;

public class ConcurrentRecordSet {
    private final Set<URI> set = new HashSet<URI>();

    public void add(WarcRecord record) {
        this.set.add(record.id());
        if (record instanceof WarcCaptureRecord) {
            this.set.addAll(((WarcCaptureRecord)record).concurrentTo());
        }
    }

    public boolean contains(WarcRecord record) {
        if (this.set.contains(record.id())) {
            return true;
        }
        if (record instanceof WarcCaptureRecord) {
            for (URI id : ((WarcCaptureRecord)record).concurrentTo()) {
                if (!this.set.contains(id)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.set.clear();
    }
}

