/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.CalendarData;
import com.github.caldav4j.model.request.CompFilter;
import com.github.caldav4j.model.request.Prop;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class CalendarQuery
extends OutputsDOMBase
implements CalDAVReportRequest {
    public static final String ELEMENT_NAME = "calendar-query";
    public static final String ELEM_ALLPROP = "allprop";
    public static final String ELEM_PROPNAME = "propname";
    public static final String ELEM_FILTER = "filter";
    private boolean allProp = false;
    private boolean propName = false;
    private Prop properties = new Prop();
    private CompFilter compFilter = null;
    private CalendarData calendarDataProp = null;

    public CalendarQuery() {
    }

    public CalendarQuery(Prop properties, CompFilter compFilter, CalendarData calendarData, boolean allProp, boolean propName) {
        this(compFilter, calendarData, allProp, propName);
        if (properties != null) {
            this.properties.addChildren(properties);
        }
    }

    public CalendarQuery(DavPropertyNameSet properties, CompFilter compFilter, CalendarData calendarData, boolean allProp, boolean propName) {
        this(compFilter, calendarData, allProp, propName);
        if (properties != null) {
            this.properties.addChildren(properties);
        }
    }

    public CalendarQuery(Collection<? extends XmlSerializable> properties, CompFilter compFilter, CalendarData calendarData, boolean allProp, boolean propName) {
        this(compFilter, calendarData, allProp, propName);
        if (properties != null) {
            this.properties.addChildren(properties);
        }
    }

    public CalendarQuery(CompFilter compFilter, CalendarData calendarData, boolean allProp, boolean propName) {
        this.compFilter = compFilter;
        this.calendarDataProp = calendarData;
        this.allProp = allProp;
        this.propName = propName;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<XmlSerializable> getChildren() {
        ArrayList<XmlSerializable> children = new ArrayList<XmlSerializable>();
        if (this.allProp) {
            children.add((XmlSerializable)new PropProperty(ELEM_ALLPROP, CalDAVConstants.NAMESPACE_WEBDAV));
        } else if (this.propName) {
            children.add((XmlSerializable)new PropProperty(ELEM_PROPNAME, CalDAVConstants.NAMESPACE_WEBDAV));
        } else if (this.properties != null && !this.properties.isEmpty() || this.calendarDataProp != null) {
            Prop temp = new Prop();
            temp.addChildren(this.properties.getChildren());
            if (this.calendarDataProp != null) {
                temp.addChild(this.calendarDataProp);
            }
            children.add((XmlSerializable)temp);
        }
        if (this.compFilter != null) {
            PropProperty filter = new PropProperty(ELEM_FILTER, CalDAVConstants.NAMESPACE_CALDAV);
            filter.addChild(this.compFilter);
            children.add((XmlSerializable)filter);
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    public boolean isAllProp() {
        return this.allProp;
    }

    public void setAllProp(boolean allProp) {
        this.allProp = allProp;
    }

    public boolean isPropName() {
        return this.propName;
    }

    public void setPropName(boolean propName) {
        this.propName = propName;
    }

    public Prop getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<PropProperty> properties) {
        this.properties.addChildren(properties);
    }

    public void setProperties(DavPropertyNameSet properties) {
        this.properties.addChildren(properties);
    }

    public void addProperty(XmlSerializable propProperty) {
        this.properties.add(propProperty);
    }

    public void addProperty(String propertyName, Namespace namespace) {
        PropProperty propProperty = new PropProperty(propertyName, namespace);
        this.properties.add((XmlSerializable)propProperty);
    }

    @Override
    protected Map<String, String> getAttributes() {
        return null;
    }

    public CompFilter getCompFilter() {
        return this.compFilter;
    }

    public void setCompFilter(CompFilter compFilter) {
        this.compFilter = compFilter;
    }

    public CalendarData getCalendarDataProp() {
        return this.calendarDataProp;
    }

    public void setCalendarDataProp(CalendarData calendarDataProp) {
        this.calendarDataProp = calendarDataProp;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.calendarDataProp != null) {
            this.calendarDataProp.validate();
        }
        if (this.compFilter == null) {
            this.throwValidationException("CompFilter cannot be null.");
        }
        this.compFilter.validate();
    }
}

