/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.rating;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.rating.RatingConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.rating.RatingCssResourceReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.rating.RatingJavaScriptResourceReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatingField<T>
extends HiddenField<T> {
    private static final long serialVersionUID = 3927736784638450199L;
    private static final Logger LOG = LoggerFactory.getLogger(RatingField.class);
    private final RatingConfig config;

    public RatingField(String id) {
        this(id, null, new RatingConfig());
    }

    public RatingField(String id, RatingConfig config) {
        this(id, null, config);
    }

    public RatingField(String id, IModel<T> model) {
        this(id, model, new RatingConfig());
    }

    public RatingField(String id, IModel<T> model, RatingConfig config) {
        super(id, model);
        Args.notNull((Object)((Object)config), (String)"config");
        this.config = config;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)RatingCssResourceReference.getInstance()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)RatingJavaScriptResourceReference.getInstance()));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.getConfig())));
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.wantAjaxNotification()) {
            this.registerChangeListener();
        }
    }

    private void registerChangeListener() {
        this.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                LOG.debug("change rate triggered");
                RatingField.this.onChange(target);
            }
        }});
    }

    protected boolean wantAjaxNotification() {
        return false;
    }

    protected void onChange(AjaxRequestTarget target) {
    }

    protected CharSequence createScript(RatingConfig config) {
        return JQuery.$((Component)this).chain((CharSequence)"rating", (Config)config, new Config[0]).get();
    }

    public RatingConfig getConfig() {
        return this.config;
    }
}

