/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.menu;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.core.sip.SipManager;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class SipDialerDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final Form<String> form = new Form("form", (IModel)Model.of((Serializable)((Object)"")));
    private final TextField<String> number = new TextField("number", (IModel)Model.of((Serializable)((Object)"")));
    private final RoomPanel room;
    @Inject
    private SipManager sipDao;

    public SipDialerDialog(String id, RoomPanel room) {
        super(id);
        this.room = room;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("1003"));
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        AjaxButton ab = new AjaxButton("submit"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                SipDialerDialog.this.onSubmit(target);
            }

            protected void onError(AjaxRequestTarget target) {
                SipDialerDialog.this.onError(target);
            }
        };
        this.form.setDefaultButton((IFormSubmittingComponent)ab);
        this.add(new Component[]{this.feedback.setOutputMarkupId(true), this.form.add(new Component[]{this.number, ab})});
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("label.hangup"), this.form, Buttons.Type.Outline_Danger){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                SipDialerDialog.this.sipDao.hangup(SipDialerDialog.this.room.getRoom());
            }

            protected void onError(AjaxRequestTarget target) {
                SipDialerDialog.this.onError(target);
            }
        });
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("1448"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                SipDialerDialog.this.onSubmit(target);
            }

            protected void onError(AjaxRequestTarget target) {
                SipDialerDialog.this.onError(target);
            }
        });
        this.addButton((Component)OmModalCloseButton.of("85"));
        super.onInitialize();
    }

    protected void onError(AjaxRequestTarget target) {
        target.add(new Component[]{this.feedback});
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.sipDao.callExternalNumber((String)this.number.getModelObject(), this.room.getRoom());
    }
}

