/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.labels;

import java.io.Serializable;
import java.util.Locale;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.label.StringLabel;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.admin.labels.LangPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class LabelsForm
extends AdminBaseForm<StringLabel> {
    private static final long serialVersionUID = 1L;
    private LangPanel panel;
    private String key;
    private String value;

    public LabelsForm(String id, LangPanel panel, StringLabel label) {
        super(id, new CompoundPropertyModel((Object)label));
        this.panel = panel;
        this.key = (String)label.getKey();
        this.value = (String)label.getValue();
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new RequiredTextField("key").setLabel((IModel)new ResourceModel("165"))});
        this.add(new Component[]{new TextArea("value")});
        this.setNewRecordVisible(true);
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> f) {
        this.key = null;
        this.value = null;
        this.setModelObject(new StringLabel(this.key, this.value));
        target.add(new Component[]{this});
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(new StringLabel(this.key, this.value));
        target.add(new Component[]{this});
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        try {
            LabelDao.update((Locale)this.panel.language.getValue(), (StringLabel)((StringLabel)this.getModelObject()));
        }
        catch (Exception e) {
            this.error((Serializable)((Object)("Unexpected error while saving label:" + e.getMessage())));
        }
        this.setNewRecordVisible(false);
        target.add(new Component[]{this.panel.listContainer});
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        try {
            LabelDao.delete((Locale)this.panel.language.getValue(), (StringLabel)((StringLabel)this.getModelObject()));
        }
        catch (Exception e) {
            this.error((Serializable)((Object)("Unexpected error while deleting label:" + e.getMessage())));
        }
        target.add(new Component[]{this.panel.listContainer});
    }
}

