/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ConstraintValidator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.metadata.ClassLoadingValidatorMappingProvider;
import org.apache.bval.jsr.metadata.ValidatorMapping;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class ConstraintDefaults
extends ClassLoadingValidatorMappingProvider {
    public static final ConstraintDefaults INSTANCE = new ConstraintDefaults();
    private static final Logger log = Logger.getLogger(ConstraintDefaults.class.getName());
    private static final String DEFAULT_CONSTRAINTS = "org/apache/bval/jsr/DefaultConstraints.properties";
    private final Properties properties = this.loadProperties("org/apache/bval/jsr/DefaultConstraints.properties");

    private ConstraintDefaults() {
    }

    private Properties loadProperties(String resource) {
        Properties result = new Properties();
        ClassLoader classloader = this.getClassLoader();
        try (InputStream stream = classloader.getResourceAsStream(resource);){
            if (stream == null) {
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, String.format("Cannot find %s", resource));
                }
            } else {
                result.load(stream);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, String.format("Cannot load %s", resource), e);
        }
        return result;
    }

    @Override
    public <A extends Annotation> ValidatorMapping<A> doGetValidatorMapping(Class<A> constraintType) {
        String validators = this.properties.getProperty(constraintType.getName());
        if (StringUtils.isBlank(validators)) {
            return null;
        }
        return new ValidatorMapping("built-in", this.load(Stream.of(StringUtils.split(validators, Character.valueOf(','))).map(String::trim), ConstraintValidator.class, e -> log.log(Level.SEVERE, "exception loading default constraint validators", (Throwable)e)).collect(Collectors.toList()));
    }

    @Override
    protected ClassLoader getClassLoader() {
        return Reflection.loaderFromClassOrThread(ConstraintDefaults.class);
    }
}

