/*
 * Decompiled with CFR 0.152.
 */
package com.martinkl.warc.mapred;

import com.martinkl.warc.WARCFileReader;
import com.martinkl.warc.WARCRecord;
import com.martinkl.warc.WARCWritable;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class WARCInputFormat
extends FileInputFormat<LongWritable, WARCWritable> {
    public RecordReader<LongWritable, WARCWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new WARCReader(job, (FileSplit)split);
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    private static class WARCReader
    implements RecordReader<LongWritable, WARCWritable> {
        private final WARCFileReader reader;

        public WARCReader(JobConf job, FileSplit split) throws IOException {
            this.reader = new WARCFileReader((Configuration)job, split.getPath());
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public WARCWritable createValue() {
            return new WARCWritable();
        }

        public boolean next(LongWritable key, WARCWritable value) throws IOException {
            try {
                WARCRecord record = this.reader.read();
                key.set(this.reader.getRecordsRead());
                value.setRecord(record);
                return true;
            }
            catch (EOFException eof) {
                return false;
            }
        }

        public long getPos() throws IOException {
            return this.reader.getBytesRead();
        }

        public float getProgress() throws IOException {
            return this.reader.getProgress();
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

