/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mat;

import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLStructure;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MatParser
extends AbstractParser {
    public static final String MATLAB_MIME_TYPE = "application/x-matlab-data";
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-matlab-data"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", MATLAB_MIME_TYPE);
        TemporaryResources tmp = TikaInputStream.isTikaInputStream((InputStream)stream) ? null : new TemporaryResources();
        try {
            TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp, (Metadata)metadata);
            MatFileReader mfr = new MatFileReader(tis.getFile());
            MatFileHeader hdr = mfr.getMatFileHeader();
            String[] parts = hdr.getDescription().split(",");
            if (parts[2].contains("Created")) {
                int lastIndex1 = parts[2].lastIndexOf("Created on:");
                String dateCreated = parts[2].substring(lastIndex1 + "Created on:".length()).trim();
                metadata.set("createdOn", dateCreated);
            }
            if (parts[1].contains("Platform")) {
                int lastIndex2 = parts[1].lastIndexOf("Platform:");
                String platform = parts[1].substring(lastIndex2 + "Platform:".length()).trim();
                metadata.set("platform", platform);
            }
            if (parts[0].contains("MATLAB")) {
                metadata.set("fileType", parts[0]);
            }
            String endianBytes = new String(hdr.getEndianIndicator(), StandardCharsets.UTF_8);
            String endianCode = String.valueOf(endianBytes.toCharArray());
            metadata.set("endian", endianCode);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.newline();
            for (Map.Entry<String, MLArray> entry : mfr.getContent().entrySet()) {
                String varName = entry.getKey();
                MLArray varData = entry.getValue();
                xhtml.element("p", varName + ":" + String.valueOf(varData));
                if (!varData.isStruct()) continue;
                MLStructure mlStructure = (MLStructure)mfr.getMLArray(varName);
                xhtml.startElement("ul");
                xhtml.newline();
                for (MLArray element : mlStructure.getAllFields()) {
                    xhtml.startElement("li");
                    xhtml.characters(String.valueOf(element));
                    if (element.isStruct()) {
                        xhtml.startElement("ul");
                        xhtml.element("li", element.contentToString());
                        xhtml.endElement("ul");
                    }
                    xhtml.endElement("li");
                }
                xhtml.endElement("ul");
            }
            xhtml.endDocument();
        }
        catch (IOException e) {
            throw new TikaException("Error parsing Matlab file with MatParser", (Throwable)e);
        }
        finally {
            if (tmp != null) {
                tmp.dispose();
            }
        }
    }

    static {
        MatFileReader.setAllowObjectDeserialization(false);
    }
}

