/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResponse
implements Serializable {
    public static final int OK = 200;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int NO_CONTENT = 204;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private static final Log LOG = LogFactory.getLog(WebResponse.class);
    private static final ByteOrderMark[] BOM_HEADERS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE};
    private final long loadTime_;
    private final WebResponseData responseData_;
    private final WebRequest request_;
    private boolean defaultCharsetUtf8_;

    public WebResponse(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, new WebRequest(url, requestMethod), loadTime);
    }

    public WebResponse(WebResponseData responseData, WebRequest request, long loadTime) {
        this.responseData_ = responseData;
        this.request_ = request;
        this.loadTime_ = loadTime;
    }

    public WebRequest getWebRequest() {
        return this.request_;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Charset getContentCharsetOrNull() {
        try (InputStream is = this.getContentAsStream();){
            Charset charset = EncodingSniffer.sniffEncoding(this.getResponseHeaders(), is);
            return charset;
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            return null;
        }
    }

    public Charset getContentCharset() {
        String contentType;
        Charset charset = this.getContentCharsetOrNull();
        if (charset == null && null != (contentType = this.getContentType()) && (this.defaultCharsetUtf8_ || DefaultPageCreator.PageType.XML == DefaultPageCreator.determinePageType(contentType))) {
            return StandardCharsets.UTF_8;
        }
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        return charset;
    }

    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharset());
    }

    public String getContentAsString(Charset encoding) {
        return this.getContentAsString(encoding, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentAsString(Charset encoding, boolean ignoreUtf8Bom) {
        if (this.responseData_ == null) return null;
        try (InputStream in = this.responseData_.getInputStreamWithBomIfApplicable(BOM_HEADERS);){
            if (in instanceof BOMInputStream) {
                try (BOMInputStream bomIn = (BOMInputStream)in;){
                    if (bomIn.hasBOM()) {
                        if (!ignoreUtf8Bom && bomIn.hasBOM(ByteOrderMark.UTF_8)) {
                            String string = IOUtils.toString((InputStream)bomIn, (Charset)StandardCharsets.UTF_8);
                            return string;
                        }
                        if (bomIn.hasBOM(ByteOrderMark.UTF_16BE)) {
                            String string = IOUtils.toString((InputStream)bomIn, (Charset)StandardCharsets.UTF_16BE);
                            return string;
                        }
                        if (bomIn.hasBOM(ByteOrderMark.UTF_16LE)) {
                            String string = IOUtils.toString((InputStream)bomIn, (Charset)StandardCharsets.UTF_16LE);
                            return string;
                        }
                    }
                    String string = IOUtils.toString((InputStream)bomIn, (Charset)encoding);
                    return string;
                }
            }
            String string = IOUtils.toString((InputStream)in, (Charset)encoding);
            return string;
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public long getContentLength() {
        if (this.responseData_ == null) {
            return 0L;
        }
        return this.responseData_.getContentLength();
    }

    public InputStream getContentAsStream() throws IOException {
        return this.responseData_.getInputStream();
    }

    public InputStream getContentAsStreamWithBomIfApplicable() throws IOException {
        if (this.responseData_ != null) {
            return this.responseData_.getInputStreamWithBomIfApplicable(BOM_HEADERS);
        }
        return null;
    }

    public long getLoadTime() {
        return this.loadTime_;
    }

    public void cleanUp() {
        if (this.responseData_ != null) {
            this.responseData_.cleanUp();
        }
    }

    public void defaultCharsetUtf8() {
        this.defaultCharsetUtf8_ = true;
    }

    public boolean isSuccess() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean isSuccessOrUseProxy() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300 || statusCode == 305;
    }

    public boolean isSuccessOrUseProxyOrNotModified() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300 || statusCode == 305 || statusCode == 304;
    }
}

