/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.util.Collection;
import java.util.TreeSet;
import org.archive.util.iterator.StringFilter;
import org.archive.util.iterator.StringTransformer;

public class TransformingPrefixStringFilter
implements StringFilter {
    TreeSet<String> filters;
    StringTransformer transformer;

    public TransformingPrefixStringFilter(Collection<String> blocks) {
        this(blocks, null);
    }

    public TransformingPrefixStringFilter(Collection<String> blocks, StringTransformer transformer) {
        this.filters = TransformingPrefixStringFilter.makeTreeSet(blocks, transformer);
        this.transformer = transformer;
    }

    public static TreeSet<String> makeTreeSet(Collection<String> blocks, StringTransformer trans) {
        TreeSet<String> tmp = new TreeSet<String>();
        for (String filter : blocks) {
            String possiblePrefix;
            if (trans != null) {
                filter = trans.transform(filter);
            }
            if ((possiblePrefix = tmp.floor(filter)) != null && filter.startsWith(possiblePrefix)) continue;
            String possibleLonger = tmp.ceiling(filter);
            if (possibleLonger != null && possibleLonger.startsWith(filter)) {
                tmp.remove(possibleLonger);
            }
            tmp.add(filter);
        }
        return tmp;
    }

    @Override
    public boolean isFiltered(String text) {
        String possiblePrefix;
        if (this.transformer != null) {
            text = this.transformer.transform(text);
        }
        return (possiblePrefix = this.filters.floor(text)) != null && text.startsWith(possiblePrefix);
    }
}

