/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final String VERSION = "0.1";
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMPRFC1123 = DateUtils.threadLocalDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP12 = DateUtils.threadLocalDateFormat("yyyyMMddHHmm");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP14 = DateUtils.threadLocalDateFormat("yyyyMMddHHmmss");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP17 = DateUtils.threadLocalDateFormat("yyyyMMddHHmmssSSS");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP17ISO8601Z = DateUtils.threadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP14ISO8601Z = DateUtils.threadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final char DEFAULT_PAD_CHAR = ' ';
    private static final int HOUR_IN_MS = 3600000;
    private static final int DAY_IN_MS = 86400000;
    public static int MAX_INT_CHAR_WIDTH = Integer.toString(Integer.MAX_VALUE).length();
    static long LAST_UNIQUE_NOW14 = 0L;
    static String LAST_TIMESTAMP14 = "";

    private static ThreadLocal<SimpleDateFormat> threadLocalDateFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> tl = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ENGLISH);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df;
            }
        };
        return tl;
    }

    public static String getRFC1123Date(Date date) {
        return TIMESTAMPRFC1123.get().format(date);
    }

    public static String get17DigitDate() {
        return DateUtils.get17DigitDate(new Date());
    }

    public static String get17DigitDate(long date) {
        return DateUtils.get17DigitDate(new Date(date));
    }

    public static String get17DigitDate(Date date) {
        return TIMESTAMP17.get().format(date);
    }

    public static String get14DigitDate() {
        return DateUtils.get14DigitDate(new Date());
    }

    public static String get14DigitDate(long date) {
        return DateUtils.get14DigitDate(new Date(date));
    }

    public static String get14DigitDate(Date d) {
        return TIMESTAMP14.get().format(d);
    }

    public static String get12DigitDate() {
        return DateUtils.get12DigitDate(new Date());
    }

    public static String get12DigitDate(long date) {
        return DateUtils.get12DigitDate(new Date(date));
    }

    public static String get12DigitDate(Date d) {
        return TIMESTAMP12.get().format(d);
    }

    public static String getLog17Date() {
        return DateUtils.getLog17Date(new Date());
    }

    public static String getLog17Date(long date) {
        return DateUtils.getLog17Date(new Date(date));
    }

    public static String getLog17Date(Date date) {
        return TIMESTAMP17ISO8601Z.get().format(date);
    }

    public static String getLog14Date() {
        return DateUtils.getLog14Date(new Date());
    }

    public static String getLog14Date(long date) {
        return DateUtils.getLog14Date(new Date(date));
    }

    public static String getLog14Date(Date date) {
        return TIMESTAMP14ISO8601Z.get().format(date);
    }

    public static Date getDate(String d) throws ParseException {
        Date date = null;
        if (d == null) {
            throw new IllegalArgumentException("Passed date is null");
        }
        switch (d.length()) {
            case 14: {
                date = DateUtils.parse14DigitDate(d);
                break;
            }
            case 17: {
                date = DateUtils.parse17DigitDate(d);
                break;
            }
            case 12: {
                date = DateUtils.parse12DigitDate(d);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                throw new ParseException("Date string must at least contain ayear: " + d, d.length());
            }
            default: {
                int i;
                if (!d.startsWith("19") && !d.startsWith("20")) {
                    throw new ParseException("Unrecognized century: " + d, 0);
                }
                if (d.length() < 8 && d.length() % 2 != 0) {
                    throw new ParseException("Incomplete month/date: " + d, d.length());
                }
                StringBuilder sb = new StringBuilder(d);
                if (sb.length() < 8) {
                    i = sb.length();
                    while (sb.length() < 8) {
                        sb.append("01");
                        i += 2;
                    }
                }
                if (sb.length() < 12) {
                    i = sb.length();
                    while (sb.length() < 12) {
                        sb.append("0");
                        ++i;
                    }
                }
                date = DateUtils.parse12DigitDate(sb.toString());
            }
        }
        return date;
    }

    public static Date parse17DigitDate(String date) throws ParseException {
        return TIMESTAMP17.get().parse(date);
    }

    public static Date parse14DigitDate(String date) throws ParseException {
        return TIMESTAMP14.get().parse(date);
    }

    public static Date parse12DigitDate(String date) throws ParseException {
        return TIMESTAMP12.get().parse(date);
    }

    public static String secondsSinceEpoch(String timestamp) throws ParseException {
        return DateUtils.zeroPadInteger((int)(DateUtils.getSecondsSinceEpoch(timestamp).getTime() / 1000L));
    }

    public static Date getSecondsSinceEpoch(String timestamp) throws ParseException {
        if (timestamp.length() < 14) {
            if (timestamp.length() < 10 && timestamp.length() % 2 == 1) {
                throw new IllegalArgumentException("Must have year, month, date, hour or second granularity: " + timestamp);
            }
            if (timestamp.length() == 4) {
                timestamp = timestamp + "01010000";
            }
            if (timestamp.length() == 6) {
                timestamp = timestamp + "010000";
            }
            if (timestamp.length() < 14) {
                timestamp = timestamp + DateUtils.padTo("", 14 - timestamp.length(), '0');
            }
        }
        return DateUtils.parse14DigitDate(timestamp);
    }

    public static String zeroPadInteger(int i) {
        return DateUtils.padTo(Integer.toString(i), MAX_INT_CHAR_WIDTH, '0');
    }

    public static String padTo(int i, int pad) {
        String n = Integer.toString(i);
        return DateUtils.padTo(n, pad);
    }

    public static String padTo(String s, int pad) {
        return DateUtils.padTo(s, pad, ' ');
    }

    public static String padTo(String s, int pad, char padChar) {
        String result = s;
        int l = s.length();
        if (l < pad) {
            StringBuffer sb = new StringBuffer(pad);
            while (l < pad) {
                sb.append(padChar);
                ++l;
            }
            sb.append(s);
            result = sb.toString();
        }
        return result;
    }

    public static boolean byteArrayEquals(byte[] lhs, byte[] rhs) {
        if (lhs == null && rhs != null || lhs != null && rhs == null) {
            return false;
        }
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    public static String doubleToString(double val, int maxFractionDigits) {
        return DateUtils.doubleToString(val, maxFractionDigits, 0);
    }

    private static String doubleToString(double val, int maxFractionDigits, int minFractionDigits) {
        NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
        f.setMaximumFractionDigits(maxFractionDigits);
        f.setMinimumFractionDigits(minFractionDigits);
        return f.format(val);
    }

    public static String formatBytesForDisplay(long amount) {
        int unitPowerOf1024;
        double displayAmount = amount;
        if (amount <= 0L) {
            return "0 B";
        }
        for (unitPowerOf1024 = 0; displayAmount >= 1024.0 && unitPowerOf1024 < 4; displayAmount /= 1024.0, ++unitPowerOf1024) {
        }
        String[] units = new String[]{" B", " KiB", " MiB", " GiB", " TiB"};
        int fractionDigits = displayAmount < 10.0 ? 1 : 0;
        return DateUtils.doubleToString(displayAmount, fractionDigits, fractionDigits) + units[unitPowerOf1024];
    }

    public static String formatMillisecondsToConventional(long time) {
        return DateUtils.formatMillisecondsToConventional(time, 5);
    }

    public static String formatMillisecondsToConventional(long duration, int unitCount) {
        if (unitCount <= 0) {
            unitCount = 5;
        }
        if (duration == 0L) {
            return "0ms";
        }
        StringBuffer sb = new StringBuffer();
        if (duration < 0L) {
            sb.append("-");
        }
        long absTime = Math.abs(duration);
        long[] thresholds = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};
        String[] units = new String[]{"d", "h", "m", "s", "ms"};
        for (int i = 0; i < thresholds.length; ++i) {
            if (absTime >= thresholds[i]) {
                sb.append(absTime / thresholds[i] + units[i]);
                absTime %= thresholds[i];
                --unitCount;
            }
            if (unitCount == 0) break;
        }
        return sb.toString();
    }

    public static synchronized String getUnique14DigitDate() {
        long effectiveNow = System.currentTimeMillis();
        effectiveNow = Math.max(effectiveNow, LAST_UNIQUE_NOW14 + 1L);
        String candidate = DateUtils.get14DigitDate(effectiveNow);
        while (candidate.equals(LAST_TIMESTAMP14)) {
            candidate = DateUtils.get14DigitDate(effectiveNow += 1000L);
        }
        LAST_UNIQUE_NOW14 = effectiveNow;
        LAST_TIMESTAMP14 = candidate;
        return candidate;
    }
}

