/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.warc;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.archive.format.http.HttpHeader;
import org.archive.format.http.HttpResponse;
import org.archive.resource.AbstractResource;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.resource.ResourceParseException;
import org.archive.util.Base32;
import org.archive.util.StreamCopy;
import org.archive.util.io.EOFNotifyingInputStream;
import org.archive.util.io.EOFObserver;
import org.archive.util.io.PushBackOneByteInputStream;

public class WARCResource
extends AbstractResource
implements EOFObserver,
ResourceConstants {
    CountingInputStream countingIS;
    private HttpResponse response;
    private DigestInputStream digIS;
    private MetaData envelope;

    public WARCResource(MetaData metaData, ResourceContainer container, HttpResponse response) throws ResourceParseException {
        super(metaData.createChild("Payload-Metadata"), container);
        this.envelope = metaData;
        this.response = response;
        long length = -1L;
        metaData.putString("Format", "WARC/1.0");
        metaData.putLong("WARC-Header-Length", response.getHeaderBytes());
        MetaData fields = metaData.createChild("WARC-Header-Metadata");
        for (HttpHeader h : response.getHeaders()) {
            String name = h.getName();
            String value = h.getValue();
            fields.putString(name, value);
            if (!name.toLowerCase().equals("content-length")) continue;
            length = Long.parseLong(value);
        }
        if (length < 0L) {
            throw new ResourceParseException(new Exception("Zero or negative length: " + length));
        }
        this.countingIS = new CountingInputStream(ByteStreams.limit((InputStream)response, (long)length));
        try {
            this.digIS = new DigestInputStream((InputStream)this.countingIS, MessageDigest.getInstance("sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public InputStream getInputStream() {
        return new EOFNotifyingInputStream(this.digIS, this);
    }

    @Override
    public void notifyEOF() throws IOException {
        String digString = Base32.encode(this.digIS.getMessageDigest().digest());
        if (this.container.isCompressed()) {
            if (!this.metaData.has("Actual-Content-Length") || this.countingIS.getCount() != this.metaData.getLong("Actual-Content-Length")) {
                this.metaData.putLong("Actual-Content-Length", this.countingIS.getCount());
            }
            this.metaData.putLong("Trailing-Slop-Length", StreamCopy.readToEOF(this.response));
            this.metaData.putString("Block-Digest", "sha1:" + digString);
        } else {
            PushBackOneByteInputStream pb1bis;
            long numNewlines;
            InputStream raw = this.response.getInner();
            if (raw instanceof PushBackOneByteInputStream && (numNewlines = StreamCopy.skipChars(pb1bis = (PushBackOneByteInputStream)((Object)raw), CR_NL_CHARS)) > 0L) {
                long payloadLength = this.countingIS.getCount();
                if (!this.metaData.has("Actual-Content-Length") || payloadLength != this.metaData.getLong("Actual-Content-Length")) {
                    this.metaData.putLong("Actual-Content-Length", payloadLength);
                }
                this.metaData.putLong("Trailing-Slop-Length", numNewlines);
                this.metaData.putString("Block-Digest", "sha1:" + digString);
            }
        }
    }

    public MetaData getEnvelopeMetaData() {
        return this.envelope;
    }
}

