/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MiserOutputStream
extends FilterOutputStream {
    protected long count;
    protected boolean passFlushes;

    public MiserOutputStream(OutputStream out) {
        this(out, true);
    }

    public MiserOutputStream(OutputStream out, boolean passFlushes) {
        super(out);
        this.passFlushes = passFlushes;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void close() throws IOException {
        this.passFlushes = true;
        super.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.passFlushes) {
            super.flush();
        }
    }
}

