/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.http;

import org.archive.format.http.HttpConstants;
import org.archive.format.http.HttpParseException;

public class HttpMessageParser
implements HttpConstants {
    protected int parseVersionStrict(byte[] buf, int start, int len) throws HttpParseException {
        String v = new String(buf, start, len, UTF8);
        if (v.compareTo("HTTP/1.0") == 0) {
            return 0;
        }
        if (v.compareTo("HTTP/1.1") == 0) {
            return 1;
        }
        if (v.compareTo("HTTP/0.9") == 0) {
            return 9;
        }
        throw new HttpParseException("Unknown version");
    }

    protected int parseVersionLax(byte[] buf, int start, int len) throws HttpParseException {
        String v = new String(buf, start, len, UTF8);
        if (v.toLowerCase().compareTo("HTTP/1.0".toLowerCase()) == 0) {
            return 0;
        }
        if (v.toLowerCase().compareTo("HTTP/1.1".toLowerCase()) == 0) {
            return 1;
        }
        if (v.toLowerCase().compareTo("HTTP/0.9".toLowerCase()) == 0) {
            return 9;
        }
        return 0;
    }
}

