/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.hostdb;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.hostdb.HostDatum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String host = null;
    protected HostDatum datum = null;
    protected Text hostText = new Text();
    protected Reducer.Context context;
    protected int purgeFailedHostsThreshold;

    public ResolverThread(String host, HostDatum datum, Reducer.Context context, int purgeFailedHostsThreshold) {
        this.hostText.set(host);
        this.host = host;
        this.datum = datum;
        this.context = context;
        this.purgeFailedHostsThreshold = purgeFailedHostsThreshold;
    }

    @Override
    public void run() {
        try {
            InetAddress inetAddr = InetAddress.getByName(this.host);
            if (this.datum.isEmpty()) {
                this.context.getCounter("UpdateHostDb", "new_known_host").increment(1L);
                this.datum.setLastCheck();
                LOG.info("{}: new_known_host {}", (Object)this.host, (Object)this.datum);
            } else if (this.datum.getDnsFailures() > 0L) {
                this.context.getCounter("UpdateHostDb", "rediscovered_host").increment(1L);
                this.datum.setLastCheck();
                this.datum.setDnsFailures(0L);
                LOG.info("{}: rediscovered_host {}", (Object)this.host, (Object)this.datum);
            } else {
                this.context.getCounter("UpdateHostDb", "existing_known_host").increment(1L);
                this.datum.setLastCheck();
                LOG.info("{}: existing_known_host {}", (Object)this.host, (Object)this.datum);
            }
            this.context.write((Object)this.hostText, (Object)this.datum);
        }
        catch (UnknownHostException e) {
            try {
                if (this.datum.isEmpty()) {
                    this.datum.setLastCheck();
                    this.datum.setDnsFailures(1L);
                    this.context.write((Object)this.hostText, (Object)this.datum);
                    this.context.getCounter("UpdateHostDb", "new_unknown_host").increment(1L);
                    LOG.info("{}: new_unknown_host {}", (Object)this.host, (Object)this.datum);
                } else {
                    this.datum.setLastCheck();
                    this.datum.incDnsFailures();
                    if (this.purgeFailedHostsThreshold == -1 || (long)this.purgeFailedHostsThreshold < this.datum.getDnsFailures()) {
                        this.context.write((Object)this.hostText, (Object)this.datum);
                        this.context.getCounter("UpdateHostDb", "existing_unknown_host").increment(1L);
                        LOG.info("{}: existing_unknown_host {}", (Object)this.host, (Object)this.datum);
                    } else {
                        this.context.getCounter("UpdateHostDb", "purged_unknown_host").increment(1L);
                        LOG.info("{}: purged_unknown_host {}", (Object)this.host, (Object)this.datum);
                    }
                }
                this.context.getCounter("UpdateHostDb", this.createFailureCounterLabel(this.datum)).increment(1L);
            }
            catch (Exception ioe) {
                LOG.warn(StringUtils.stringifyException((Throwable)ioe));
            }
        }
        catch (Exception e) {
            LOG.warn(StringUtils.stringifyException((Throwable)e));
        }
        this.context.getCounter("UpdateHostDb", "checked_hosts").increment(1L);
    }

    private String createFailureCounterLabel(HostDatum datum) {
        String label = null;
        long n = datum.numFailures();
        label = n < 4L ? Long.toString(n) : (n > 3L && n < 11L ? "4-10" : ">10");
        return label + "_times_failed";
    }
}

