/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.function.Consumer;
import jpt.sun.tools.javac.comp.AttrContext;
import jpt.sun.tools.javac.comp.CompileStates;
import jpt.sun.tools.javac.comp.Env;
import jpt.sun.tools.javac.main.JavaCompiler;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Pair;
import org.netbeans.lib.nbjavac.services.CancelService;

public class NBJavaCompiler
extends JavaCompiler {
    private final CancelService cancelService;
    private Consumer<Env<AttrContext>> desugarCallback;
    private boolean desugaring;

    public static void preRegister(Context context) {
        context.put(compilerKey, new Context.Factory<JavaCompiler>(){

            @Override
            public JavaCompiler make(Context c) {
                return new NBJavaCompiler(c);
            }
        });
    }

    public NBJavaCompiler(Context context) {
        super(context);
        this.cancelService = CancelService.instance(context);
    }

    @Override
    public void processAnnotations(List<JCTree.JCCompilationUnit> roots, Collection<String> classnames) {
        if (roots.isEmpty()) {
            super.processAnnotations(roots, classnames);
        } else {
            this.setOrigin(((JCTree.JCCompilationUnit)roots.head).sourcefile.toUri().toString());
            try {
                super.processAnnotations(roots, classnames);
            }
            finally {
                this.setOrigin("");
            }
        }
    }

    private void setOrigin(String origin) {
        this.fileManager.handleOption("apt-origin", Collections.singletonList(origin).iterator());
    }

    public void setDesugarCallback(Consumer<Env<AttrContext>> callback) {
        this.desugarCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void desugar(Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
        boolean prevDesugaring = this.desugaring;
        try {
            this.desugaring = true;
            if (this.desugarCallback != null) {
                this.desugarCallback.accept(env);
            }
            super.desugar(env, results);
        }
        finally {
            this.desugaring = prevDesugaring;
        }
    }

    void maybeInvokeDesugarCallback(Env<AttrContext> env) {
        if (this.desugaring && this.desugarCallback != null && this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) {
            this.desugarCallback.accept(env);
        }
    }
}

