/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import java.io.IOException;
import java.time.DateTimeException;
import java.util.Collection;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.storage.csv.FixedSizeList;
import org.apache.sis.internal.storage.csv.GeometryParser;
import org.apache.sis.internal.storage.csv.Store;
import org.apache.sis.internal.storage.csv.TimeEncoding;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.BackingStoreException;

class FeatureIterator
implements Spliterator<AbstractFeature> {
    static final int TRAJECTORY_COLUMN = 3;
    final Store store;
    final String[] propertyNames;
    final ObjectConverter<String, ?>[] converters;
    final Object[] values;
    private AtomicInteger splitCount;

    FeatureIterator(Store store) {
        this.store = store;
        Collection<AbstractIdentifiedType> collection = store.featureType.getProperties(true);
        this.converters = new ObjectConverter[collection.size()];
        this.values = new Object[this.converters.length];
        this.propertyNames = new String[this.converters.length];
        int n = -1;
        for (AbstractIdentifiedType abstractIdentifiedType : collection) {
            ObjectConverter<String, double[]> objectConverter;
            this.propertyNames[++n] = abstractIdentifiedType.getName().tip().toString();
            switch (n) {
                case 1: 
                case 2: {
                    TimeEncoding timeEncoding = store.timeEncoding();
                    if (timeEncoding != null) {
                        objectConverter = timeEncoding;
                        break;
                    }
                }
                case 3: {
                    if (store.hasTrajectories()) {
                        objectConverter = GeometryParser.INSTANCE;
                        break;
                    }
                }
                default: {
                    objectConverter = ObjectConverters.find(String.class, ((DefaultAttributeType)abstractIdentifiedType).getValueClass());
                }
            }
            this.converters[n] = objectConverter;
        }
    }

    private FeatureIterator(FeatureIterator featureIterator) {
        this.store = featureIterator.store;
        this.splitCount = featureIterator.splitCount;
        this.converters = featureIterator.converters;
        this.propertyNames = featureIterator.propertyNames;
        this.values = new Object[this.converters.length];
    }

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        if (this.splitCount == null) {
            this.splitCount = new AtomicInteger();
        }
        if (this.splitCount.incrementAndGet() < 8) {
            return new FeatureIterator(this);
        }
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) {
        try {
            return this.read(consumer, false);
        }
        catch (IOException | IllegalArgumentException | DateTimeException exception) {
            throw new BackingStoreException(this.store.canNotParseFile(), exception);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> consumer) {
        try {
            this.read(consumer, true);
        }
        catch (IOException | IllegalArgumentException | DateTimeException exception) {
            throw new BackingStoreException(this.store.canNotParseFile(), exception);
        }
    }

    private boolean read(Consumer<? super AbstractFeature> consumer, boolean bl) throws IOException {
        String string;
        FixedSizeList fixedSizeList = new FixedSizeList(this.values);
        while ((string = this.store.readLine()) != null) {
            int n;
            Store.split(string, fixedSizeList);
            AbstractFeature abstractFeature = this.store.featureType.newInstance();
            int n2 = fixedSizeList.size();
            for (n = 0; n < n2; ++n) {
                this.values[n] = this.converters[n].apply((String)this.values[n]);
                abstractFeature.setPropertyValue(this.propertyNames[n], this.values[n]);
            }
            n2 = this.values.length;
            while (n < n2) {
                abstractFeature.setPropertyValue(this.propertyNames[n], this.values[n]);
                ++n;
            }
            consumer.accept(abstractFeature);
            if (!bl) {
                return true;
            }
            fixedSizeList.clear();
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1280;
    }
}

