/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingBeanPropertyMeta;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingMetaProvider;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public class UrlEncodingSerializer
extends UonSerializer
implements UrlEncodingMetaProvider {
    public static final UrlEncodingSerializer DEFAULT = new UrlEncodingSerializer(UrlEncodingSerializer.create());
    public static final UrlEncodingSerializer DEFAULT_PLAINTEXT = new PlainText(UrlEncodingSerializer.create());
    public static final UrlEncodingSerializer DEFAULT_EXPANDED = new Expanded(UrlEncodingSerializer.create());
    public static final UrlEncodingSerializer DEFAULT_READABLE = new Readable(UrlEncodingSerializer.create());
    final boolean expandedParams;
    private final Map<ClassMeta<?>, UrlEncodingClassMeta> urlEncodingClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, UrlEncodingBeanPropertyMeta> urlEncodingBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UrlEncodingBeanPropertyMeta>();

    public static Builder create() {
        return new Builder();
    }

    public UrlEncodingSerializer(Builder builder) {
        super(builder.encoding());
        this.expandedParams = builder.expandedParams;
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public UrlEncodingSerializerSession.Builder createSession() {
        return UrlEncodingSerializerSession.create(this);
    }

    @Override
    public UrlEncodingSerializerSession getSession() {
        return this.createSession().build();
    }

    @Override
    public UrlEncodingClassMeta getUrlEncodingClassMeta(ClassMeta<?> cm) {
        UrlEncodingClassMeta m = this.urlEncodingClassMetas.get(cm);
        if (m == null) {
            m = new UrlEncodingClassMeta(cm, this);
            this.urlEncodingClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public UrlEncodingBeanPropertyMeta getUrlEncodingBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UrlEncodingBeanPropertyMeta.DEFAULT;
        }
        UrlEncodingBeanPropertyMeta m = this.urlEncodingBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UrlEncodingBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.urlEncodingBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final boolean isExpandedParams() {
        return this.expandedParams;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("expandedParams", this.expandedParams);
    }

    @FluentSetters
    public static class Builder
    extends UonSerializer.Builder {
        private static final Cache<HashKey, UrlEncodingSerializer> CACHE = Cache.of(HashKey.class, UrlEncodingSerializer.class).build();
        boolean expandedParams;

        protected Builder() {
            this.produces("application/x-www-form-urlencoded");
            this.expandedParams = this.env("UrlEncoding.expandedParams", false);
        }

        protected Builder(UrlEncodingSerializer copyFrom) {
            super(copyFrom);
            this.expandedParams = copyFrom.expandedParams;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.expandedParams = copyFrom.expandedParams;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public UrlEncodingSerializer build() {
            return this.cache(CACHE).build(UrlEncodingSerializer.class);
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(super.hashKey(), this.expandedParams);
        }

        @FluentSetter
        public Builder expandedParams() {
            return this.expandedParams(true);
        }

        @FluentSetter
        public Builder expandedParams(boolean value) {
            this.expandedParams = value;
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addBeanTypes(boolean value) {
            super.addBeanTypes(value);
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder addRootType(boolean value) {
            super.addRootType(value);
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder keepNullProperties(boolean value) {
            super.keepNullProperties(value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends SerializerListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder produces(String value) {
            super.produces(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortCollections(boolean value) {
            super.sortCollections(value);
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sortMaps(boolean value) {
            super.sortMaps(value);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyCollections(boolean value) {
            super.trimEmptyCollections(value);
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimEmptyMaps(boolean value) {
            super.trimEmptyMaps(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder quoteCharOverride(char value) {
            super.quoteCharOverride(value);
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder useWhitespace(boolean value) {
            super.useWhitespace(value);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }

        @Override
        public Builder addBeanTypesUon() {
            super.addBeanTypesUon();
            return this;
        }

        @Override
        public Builder addBeanTypesUon(boolean value) {
            super.addBeanTypesUon(value);
            return this;
        }

        @Override
        public Builder encoding() {
            super.encoding();
            return this;
        }

        @Override
        public Builder paramFormat(ParamFormat value) {
            super.paramFormat(value);
            return this;
        }

        @Override
        public Builder paramFormatPlain() {
            super.paramFormatPlain();
            return this;
        }

        @Override
        public Builder quoteCharUon(char value) {
            super.quoteCharUon(value);
            return this;
        }
    }

    public static class PlainText
    extends UrlEncodingSerializer {
        public PlainText(Builder builder) {
            super(builder.paramFormatPlain());
        }
    }

    public static class Expanded
    extends UrlEncodingSerializer {
        public Expanded(Builder builder) {
            super(builder.expandedParams());
        }
    }

    public static class Readable
    extends UrlEncodingSerializer {
        public Readable(Builder builder) {
            super(builder.useWhitespace());
        }
    }
}

